/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.dajiangnan.xxx.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisService {
    private static Logger logger = Logger.getLogger(RedisService.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public void putObject(String key, String subKey, Serializable serializable, int expireSeconds) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)subKey, (Object)serializable);
            this.redisTemplate.expire((Object)key, (long)expireSeconds, TimeUnit.SECONDS);
            logger.debug((Object)("put: KEY=" + key + " SUBKEY=" + subKey + " VALUE=" + serializable + " EXPIRESECONDS=" + expireSeconds));
        }
        catch (RedisConnectionFailureException e) {
            logger.debug((Object)("put : KEY=" + key + " SUBKEY=" + subKey + " FAIL"));
        }
    }

    public Object getObject(String key, String subKey) {
        Object obj = null;
        if (this.redisTemplate.opsForHash().hasKey((Object)key, (Object)subKey).booleanValue()) {
            obj = this.redisTemplate.opsForHash().get((Object)key, (Object)subKey);
        }
        logger.debug((Object)("getObject: KEY=" + key + " SUBKEY=" + subKey + " RESULT=" + (obj == null ? "IS NULL" : obj)));
        return obj;
    }

    public List<Object> getObjects(String key) {
        ArrayList<Object> objs = null;
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object obj : this.redisTemplate.opsForHash().values((Object)key)) {
                ret.add(obj);
            }
            objs = ret;
        }
        logger.debug((Object)("getObjects: KEY=" + key + " RESULT " + (objs == null ? "IS NULL" : "SIZE =" + objs.size())));
        return objs;
    }

    public void cleanObject(String key) {
        logger.debug((Object)("cleanObject: KEY=" + key));
        this.redisTemplate.delete((Object)key);
    }

    public Long size(String key) {
        Long l = 0L;
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            l = this.redisTemplate.opsForHash().size((Object)key);
        }
        logger.debug((Object)("size: KEY=" + key + " RESULT=" + l));
        return l;
    }

    public Serializable getAndRemove(String key) {
        Serializable serializable = null;
        try {
            if (this.redisTemplate.opsForHash().hasKey((Object)key, (Object)"").booleanValue()) {
                serializable = (Serializable)this.redisTemplate.opsForHash().get((Object)key, (Object)"");
                this.redisTemplate.delete((Object)key);
            }
            logger.debug((Object)("get: KEY=" + key + " Serializable = " + serializable));
        }
        catch (RedisConnectionFailureException e) {
            logger.debug((Object)("get: KEY=" + key + " FAIL"));
        }
        return serializable;
    }
}

