/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.dajiangnan.xxx.service;

import com.aspire.nm.component.commonUtil.constants.ConstantConfig;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class EhcacheService {
    private static Logger logger = Logger.getLogger(EhcacheService.class);
    private CacheManager cacheManager;
    private Cache cache;

    public void init() {
        this.cacheManager = new CacheManager(IOUtils.toInputStream((String)ConstantConfig.getContentValue((String)"config/xml/ehcache.xml")));
        this.cache = this.cacheManager.getCache("acache");
        logger.debug((Object)"init cache acache");
    }

    public void destroy() {
        logger.debug((Object)"destroy cacheManager");
        this.cacheManager.shutdown();
    }

    public void put(String key, String value) {
        this.cache.put(new Element((Serializable)((Object)key), (Serializable)((Object)value)));
        this.cache.flush();
        logger.debug((Object)("put key = " + key + " value = " + value));
    }

    public String get(String key) {
        Element e = this.cache.get((Serializable)((Object)key));
        if (e != null) {
            String value = (String)e.getObjectValue();
            logger.debug((Object)("get key = " + key + " value = " + value));
            return value;
        }
        logger.debug((Object)("get key = " + key + " value = null"));
        return null;
    }

    public String getAndRemove(String key) {
        Element e = this.cache.get((Serializable)((Object)key));
        if (e != null) {
            this.cache.remove((Serializable)((Object)key));
            String value = (String)e.getObjectValue();
            logger.debug((Object)("getAndRemove key = " + key + " value = " + value));
            return value;
        }
        logger.debug((Object)("getAndRemove key = " + key + " value = null"));
        return null;
    }
}

