/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.dajiangnan.xxx.service;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Resource;
import net.oschina.dajiangnan.xxx.boot.Main;
import net.oschina.dajiangnan.xxx.service.EhcacheService;
import net.oschina.dajiangnan.xxx.service.RedisService;
import net.oschina.dajiangnan.xxx.service.YService;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BootService
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
Runnable {
    private static Logger logger = Logger.getLogger(BootService.class);
    @Resource
    private YService yService;
    @Value(value="${xxx_value}")
    private int xxx_value;
    private ApplicationContext applicationContext;
    private CountDownLatch threadDestroyCountDownLatch;
    private boolean stop;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug((Object)this.xxx_value);
        new Thread(this).start();
    }

    public void destroy() throws Exception {
        this.stop = true;
        this.threadDestroyCountDownLatch.await();
        logger.debug((Object)"destory");
    }

    @Override
    public void run() {
        this.threadDestroyCountDownLatch = new CountDownLatch(1);
        while (!this.stop) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        this.threadDestroyCountDownLatch.countDown();
    }

    public void testService(String testType) {
        if (testType.equals(Main.TESTTYPE.REDIS.toString())) {
            this.testRedisService();
        } else if (!testType.equals(Main.TESTTYPE.QUARTZ.toString())) {
            if (testType.equals(Main.TESTTYPE.EHCACHE.toString())) {
                this.testEhcacheService();
            } else {
                throw new RuntimeException("testType = " + testType + " unKnow");
            }
        }
    }

    private void testRedisService() {
        RedisService redisService = (RedisService)Main.springHelper.getBean(RedisService.class);
        int expiresec = 5;
        redisService.putObject("1", "", (Serializable)((Object)"a"), expiresec);
        while (redisService.getObject("1", "") != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void testEhcacheService() {
        String value;
        EhcacheService ehcacheService = (EhcacheService)Main.springHelper.getBean(EhcacheService.class);
        String key = "a";
        ehcacheService.put(key, "1");
        do {
            try {
                Thread.sleep(12000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while ((value = ehcacheService.get(key)) != null);
    }
}

