package net.oschina.dajiangnan.xxx.service.ehcache;


import org.apache.log4j.Logger;


import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;



public class MyCacheEventListener implements CacheEventListener {
    
    private static Logger logger = Logger.getLogger(MyCacheEventListener.class);
    
    @Override
    public void notifyElementPut(Ehcache cache, Element element)
          throws CacheException {
        logger.debug(cache.getName()+","+element.getObjectKey()+","+element.getObjectValue());
    }
    @Override
    public void notifyElementRemoved(Ehcache cache, Element element)
          throws CacheException {
        logger.debug(cache.getName()+","+element.getObjectKey());
    }
  
    
  
    @Override
    public void notifyElementUpdated(Ehcache cache, Element element)
          throws CacheException {
        logger.debug(cache.getName()+","+element.getObjectKey()+","+element.getObjectValue());
    }
    
  
    @Override
    public void notifyElementExpired(Ehcache cache, Element element) {
        logger.debug(cache.getName()+","+element.getObjectKey()+","+element.getObjectValue());
    }
  
    //驱除notify,内存满,磁盘满
    @Override
    public void notifyElementEvicted(Ehcache cache, Element element) {
        logger.debug(cache.getName()+","+element.getObjectKey()+","+element.getObjectValue());
    }
  
    @Override
    public void notifyRemoveAll(Ehcache cache) {
        logger.debug(cache.getName());
    }
  
    @Override
    public void dispose() {
    }
   
    public Object clone() throws CloneNotSupportedException {
       throw new CloneNotSupportedException();
    }
  
 }