package net.oschina.dajiangnan.xxx.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.apache.log4j.Logger;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.core.RedisTemplate;


public class RedisService {

    private static Logger logger = Logger.getLogger(RedisService.class);
    
    
    
    
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    
    
    
    /**
     * 向缓存增加一个对象存储
     * @param key key
     * @param subKey subKey
     * @param object 存储的对象
     * @param expireSeconds (针对key的)过期时间，单位秒
     */
    public void putObject(String key,String subKey,Serializable serializable,int expireSeconds){
        try{
            redisTemplate.opsForHash().put(key, subKey, serializable);
            redisTemplate.expire(key, expireSeconds, TimeUnit.SECONDS);
            logger.debug("put: KEY=" + key +" SUBKEY=" + subKey+ " VALUE=" +serializable + " EXPIRESECONDS="+expireSeconds);
        }catch(RedisConnectionFailureException e){
            logger.debug("put : KEY=" + key +" SUBKEY=" + subKey + " FAIL");
        }
        
    }
    /**
     * 根据key和subKey获取一个对象
     */
    public Object getObject(String key,String subKey){
        Object obj = null;
        if(redisTemplate.opsForHash().hasKey(key, subKey))
            obj = (Object) redisTemplate.opsForHash().get(key,subKey);
        logger.debug("getObject: KEY=" + key +" SUBKEY=" + subKey+ " RESULT="+(obj==null?"IS NULL":obj));
        return obj;
    }
    
    /**
     * 根据key获取多个subkey对象的list
     * @param key
     * @return
     */
    public List<Object> getObjects(String key){
        List<Object> objs = null;
        if(redisTemplate.hasKey(key)){
            List<Object> ret=new ArrayList<Object>();
            for(Object obj:redisTemplate.opsForHash().values(key)){
                ret.add(obj);
            }
            objs = ret;
        }
        logger.debug("getObjects: KEY=" + key +" RESULT "+(objs==null?"IS NULL":"SIZE ="+ objs.size()));
        return objs;
    }
    
    
    /**
     * 清空key对应的所有对象
     * @param key
     */
    public void cleanObject(String key){
        logger.debug("cleanObject: KEY=" + key);
        redisTemplate.delete(key);
    }
    
    
    /**
     * 根据key获取对应的对象个数
     * @param key
     * @return
     */
    public Long size(String key){
        Long l = 0L;
        if(redisTemplate.hasKey(key))
            l = redisTemplate.opsForHash().size(key);
        logger.debug("size: KEY=" + key +" RESULT="+ l);
        return l;
    }
    
    
    /**
     * 获取并删除
     * @param key
     * @return
     */
    public Serializable getAndRemove(String key) {
        
        Serializable serializable = null;
        try{
            if(redisTemplate.opsForHash().hasKey(key, "")){
                serializable = (Serializable) redisTemplate.opsForHash().get(key,"");
                redisTemplate.delete(key);
            }
            logger.debug("get: KEY=" + key + " Serializable = " + serializable);
        }catch(RedisConnectionFailureException e){
            logger.debug("get: KEY=" + key + " FAIL");
        }
        return serializable;
    
    }

}
