package net.oschina.dajiangnan.xxx.service;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import com.aspire.nm.component.commonUtil.constants.ConstantConfig;


public class EhcacheService {

    private static Logger logger = Logger.getLogger(EhcacheService.class);
    
    
    private CacheManager cacheManager;
    private Cache cache;
    
    public void init(){
        //动态替换一些配置的值
        cacheManager = new CacheManager(IOUtils.toInputStream(ConstantConfig.getContentValue("config/xml/ehcache.xml")));
        cache = cacheManager.getCache("acache");
        logger.debug("init cache acache");
    }
    public void destroy() {
        logger.debug("destroy cacheManager");
        cacheManager.shutdown();
    }
    
    
    public void put(String key, String value) {
        cache.put(new Element(key,value));
        cache.flush();//for accurate expire
        logger.debug("put key = "+key+" value = "+value);
    }
    
    
    //内存过期由get操作引发
    public String get(String key) {
        Element e = cache.get(key);
        if(e != null){
            String value = (String)e.getObjectValue();
            logger.debug("get key = "+key+" value = " + value);
            return value;
        }else{
            logger.debug("get key = "+key+" value = null");
            return null;
        }
    }
    public String getAndRemove(String key) {
        Element e = cache.get(key);
        if(e != null){
            cache.remove(key);
            String value = (String)e.getObjectValue();
            logger.debug("getAndRemove key = "+key+" value = " + value);
            return value;
        }else{
            logger.debug("getAndRemove key = "+key+" value = null");
            return null;
        }
    }
    
}
