package net.oschina.dajiangnan.xxx.service;


import java.util.concurrent.CountDownLatch;

import javax.annotation.Resource;

import net.oschina.dajiangnan.xxx.boot.Main;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;


public class BootService implements ApplicationContextAware,InitializingBean,DisposableBean,Runnable{

    
    private static Logger logger = Logger.getLogger(BootService.class);
    
    @Resource
    private YService yService;
    
    @Value("${xxx_value}")
    private int xxx_value;

    
    
    @SuppressWarnings("unused")
    private ApplicationContext applicationContext;  
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
    
    
    
    
    @Override
    public void afterPropertiesSet() throws Exception {
        logger.debug(xxx_value);
        new Thread(this).start();
    }


    @Override
    public void destroy() throws Exception {
        stop = true;
        threadDestroyCountDownLatch.await();
        logger.debug("destory");
    }


    private CountDownLatch threadDestroyCountDownLatch;
    private boolean stop;
    @Override
    public void run() {
        threadDestroyCountDownLatch = new CountDownLatch(1);
        while(!stop){
//            logger.debug("run ...");
            try {
                Thread.sleep(1000 * 2);
            } catch (InterruptedException e) {
                logger.error(e);
            }
        }
        threadDestroyCountDownLatch.countDown();
    } 
    
    
    
    
    public void testService(String testType){
        if(testType.equals(Main.TESTTYPE.REDIS.toString())){
            testRedisService();
        }else if(testType.equals(Main.TESTTYPE.QUARTZ.toString())){
        }else if(testType.equals(Main.TESTTYPE.EHCACHE.toString())){
            testEhcacheService();
        }else{
            throw new RuntimeException("testType = " + testType + " unKnow");
        }
    }
    
    
    
    private void testRedisService(){
        
        RedisService redisService = Main.springHelper.getBean(RedisService.class);
        
        int expiresec = 5;
        
        redisService.putObject("1", "", "a", expiresec);
        while(redisService.getObject("1","") != null){
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        
    }
    
    private void testEhcacheService(){
        
        EhcacheService ehcacheService = Main.springHelper.getBean(EhcacheService.class);
        
        String key = "a";
        
        ehcacheService.put(key, "1");
        while(true){
            try {
                Thread.sleep(1000 * 12);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            String value = ehcacheService.get(key);
            if(value == null){
                break;
            }
        }
    }
}
