/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.validate;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.plugins.KeyWordVerify;
import com.aspire.nm.component.cmppserver.plugins.TerminalIdVerify;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.util.LogService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CmppSubmitPacketCheck
implements InitializingBean {
    @Value(value="${terminalIdVerifyImplClassName}")
    private String terminalIdVerifyImplClassName;
    @Value(value="${keyWordVerifyImplClassName}")
    private String keyWordVerifyImplClassName;
    private TerminalIdVerify terminalIdVerify;
    private KeyWordVerify keyWordVerify;
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;

    public void afterPropertiesSet() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!StringUtils.isEmpty((CharSequence)this.terminalIdVerifyImplClassName)) {
            this.terminalIdVerify = (TerminalIdVerify)Class.forName(this.terminalIdVerifyImplClassName).newInstance();
        }
        if (!StringUtils.isEmpty((CharSequence)this.keyWordVerifyImplClassName)) {
            this.keyWordVerify = (KeyWordVerify)Class.forName(this.keyWordVerifyImplClassName).newInstance();
        }
    }

    public int check(CmppSubmitPacket pk, IoSession session, Version version) {
        int i;
        if (version.isSingleMOVersion()) {
            return CmppSubmitRespPacket.RESULT_REJECT;
        }
        if (pk.getSrcId() == null || pk.getSrcId().trim().equals("") || pk.getSrcId().trim().length() > 20) {
            return CmppSubmitRespPacket.RESULT_SRC_ID_ERR;
        }
        if (pk.getServiceId() == null || pk.getServiceId().trim().equals("")) {
            return CmppSubmitRespPacket.RESULT_SERVICE_ID_ERR;
        }
        if (pk.getFeeType().length() != 2) {
            return CmppSubmitRespPacket.RESULT_FEETYPE_ERR;
        }
        if (pk.getFeeCode() != null && !pk.getFeeCode().trim().equals("") && !pk.getFeeCode().matches("\\d+")) {
            return CmppSubmitRespPacket.RESULT_FEE_CODE_ERR;
        }
        if (pk.getMsgLength() <= 0) {
            return CmppSubmitRespPacket.RESULT_MSG_LENGTH_ERR;
        }
        if (pk.getMsgFmt() != 24 && (pk.getMsgFmt() == 0 && pk.getMsgLength() >= 160 || pk.getMsgFmt() != 0 && pk.getMsgLength() > 140)) {
            return CmppSubmitRespPacket.RESULT_MSG_TOO_LONG;
        }
        UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(session);
        ClientConfig clientConfig = this.sysRunTimeService.getClientConfig(userRunTime.getUser());
        if (clientConfig.getServiceId() != null && !pk.getServiceId().equals(clientConfig.getServiceId())) {
            return CmppSubmitRespPacket.RESULT_SERVICE_ID_ERR;
        }
        if (clientConfig.getSrcid() != null && !pk.getSrcId().startsWith(clientConfig.getSrcid())) {
            return CmppSubmitRespPacket.RESULT_SRC_ID_ERR;
        }
        if (this.terminalIdVerify != null) {
            for (String mobile : pk.getDestTerminalId()) {
                if (this.terminalIdVerify.verify(mobile)) continue;
                return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_ERR;
            }
        }
        if (clientConfig.getDayMtLimit() != 0 && userRunTime.getMoMtCounter().getMtCounter().getDailyCount().getCount().get() > (long)clientConfig.getDayMtLimit()) {
            return CmppSubmitRespPacket.RESULT_DAYLIMIT_ERR;
        }
        int mtLimitInsec = clientConfig.getMtLimitInSec();
        if (mtLimitInsec != 0 && userRunTime.getConnection(session).getMtSpeedController().isTimeLimitInSecond(mtLimitInsec, false)) {
            return CmppSubmitRespPacket.RESULT_SECONDLIMIT_ERR;
        }
        if (clientConfig.getBlackDestTerminalId() != null) {
            for (i = 0; i < pk.getDestTerminalId().length; ++i) {
                if (!clientConfig.getBlackDestTerminalId().contains(pk.getDestTerminalId()[i])) continue;
                return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_BLACK_ERR;
            }
        }
        if (clientConfig.getWhileDestTerminalId() != null) {
            for (i = 0; i < pk.getDestTerminalId().length; ++i) {
                if (clientConfig.getWhileDestTerminalId().contains(pk.getDestTerminalId()[i])) continue;
                return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_WHILE_ERR;
            }
        }
        if (this.keyWordVerify != null && !this.keyWordVerify.verify(pk.getMsgContentDecoded())) {
            return CmppSubmitRespPacket.RESULT_FILTER_KEYWORD;
        }
        return CmppSubmitRespPacket.RESULT_OK;
    }
}

