/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.util;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppTerminatePacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppTerminateRespPacket;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.commonUtil.log.dynamicLogger.DynamicLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    @Resource
    private SysRunTimeService sysRunTimeService;
    private static DynamicLogger warnFromlogger = new DynamicLogger("Warn", "unKnowUser");
    private static DynamicLogger activeTologger = new DynamicLogger("ActiveTo", "unKnowUser");
    private static DynamicLogger activeToResplogger = new DynamicLogger("ActiveToResp", "unKnowUser");
    private static DynamicLogger activeFromlogger = new DynamicLogger("ActiveFrom", "unKnowUser");
    private static DynamicLogger activeFromResplogger = new DynamicLogger("ActiveFromResp", "unKnowUser");
    private static DynamicLogger processSubmitlogger = new DynamicLogger("ProcessSubmit", "unKnowUser");
    private static DynamicLogger submitlogger = new DynamicLogger("Submit", "unKnowUser");
    private static DynamicLogger submitResplogger = new DynamicLogger("SubmitResp", "unKnowUser");
    private static DynamicLogger connectlogger = new DynamicLogger("Connect", "unKnowUser");
    private static DynamicLogger deliverlogger = new DynamicLogger("Deliver", "unKnowUser");
    private static DynamicLogger deliverResplogger = new DynamicLogger("DeliverResp", "unKnowUser");
    private static DynamicLogger terminatelogger = new DynamicLogger("Terminate", "unKnowUser");
    private static DynamicLogger terminateResplogger = new DynamicLogger("TerminateResp", "unKnowUser");
    private static DynamicLogger closelogger = new DynamicLogger("Close", "unKnowUser");
    private static DynamicLogger ioExceptionlogger = new DynamicLogger("IoException", "unKnowUser");
    private static DynamicLogger exceptionlogger = new DynamicLogger("CmppException", "unKnowUser");
    private static DynamicLogger debuglogger = new DynamicLogger("CmppDebug", "unKnowUser");

    public void refuseIp(IoSession session) {
        warnFromlogger.debug((Object)(this.getRemoteAddress(session) + "isRefuseIp"));
    }

    public void versionErr(IoSession session) {
        warnFromlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + "versionErr"));
    }

    public void reSendCmppConnectPacket(IoSession session) {
        warnFromlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + "reSendCmppConnectPacket"));
    }

    public void sendCmppPacketWithUnConnected(IoSession session) {
        warnFromlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + "sendCmppPacketWithUnConnected"));
    }

    public void activeTo(IoSession session, CmppActiveTestPacket cmppActiveTestPacket) {
        activeTologger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppActiveTestPacket.toString()));
    }

    public void activeToResp(IoSession session, CmppActiveTestRespPacket cmppActiveTestRespPacket) {
        activeToResplogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppActiveTestRespPacket));
    }

    public void activeFrom(IoSession session, CmppActiveTestPacket cmppActiveTestPacket) {
        activeFromlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppActiveTestPacket.toString()));
    }

    public void activeFromResp(IoSession session, CmppActiveTestRespPacket cmppActiveTestRespPacket) {
        activeFromResplogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppActiveTestRespPacket));
    }

    public void processSubmit(IoSession session, CmppSubmitPacket cmppSubmitPacket) {
        processSubmitlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppSubmitPacket.toString()));
    }

    public void submit(IoSession session, CmppSubmitPacket cmppSubmitPacket) {
        submitlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppSubmitPacket.toString()));
    }

    public void submitResp(IoSession session, CmppSubmitRespPacket cmppSubmitRespPacket) {
        submitResplogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppSubmitRespPacket.toString()));
    }

    public void connect(IoSession session, CmppConnectPacket cmppConnectPacket) {
        connectlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppConnectPacket.toString()));
    }

    public void connectResp(IoSession session, CmppConnectRespPacket cmppConnectRespPacket) {
        connectlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppConnectRespPacket.toString()));
    }

    public void deliver(String user, CmppDeliverPacket cmppDeliverPacket) {
        deliverlogger.debug(user, (Object)cmppDeliverPacket.toString());
    }

    public void deliverResp(IoSession session, CmppDeliverRespPacket cmppDeliverRespPacket) {
        deliverResplogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppDeliverRespPacket.toString()));
    }

    public void terminate(IoSession session, CmppTerminatePacket cmppTerminatePacket) {
        terminatelogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppTerminatePacket.toString()));
    }

    public void terminateResp(IoSession session, CmppTerminateRespPacket cmppTerminateRespPacket) {
        terminateResplogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + cmppTerminateRespPacket.toString()));
    }

    public void close(IoSession session) {
        closelogger.debug(this.getUser(session), (Object)this.getRemoteAddress(session));
    }

    public void throwAble(IoSession session, Throwable cause) {
        if (cause instanceof IOException) {
            ioExceptionlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + this.getStackTrace(cause)));
        } else {
            exceptionlogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + this.getStackTrace(cause)));
        }
    }

    public void debug(IoSession session, Class<?> c, Object obj, String message) {
        debuglogger.debug(this.getUser(session), (Object)(this.getRemoteAddress(session) + "  " + c.getName() + " " + obj + " " + message));
    }

    private String getUser(IoSession session) {
        UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(session);
        if (userRunTime == null) {
            return null;
        }
        return userRunTime.getUser();
    }

    private String getRemoteAddress(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        if (remoteAddress != null) {
            String hostAddr = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
            int port = ((InetSocketAddress)remoteAddress).getPort();
            return "\u3010" + hostAddr + ":" + port + "\u3011   ";
        }
        return null;
    }

    private String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return "\r\n" + sw.toString() + "\r\n";
    }
}

