/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Resource;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CmppAcceptor {
    @Resource(name="ioAcceptor")
    private SocketAcceptor acceptor;
    @Value(value="${cmppserver.serverPort}")
    private int serverPort;

    public void start() throws IOException {
        SocketSessionConfig sessionConfig = this.acceptor.getSessionConfig();
        sessionConfig.setReceiveBufferSize(0x400000);
        sessionConfig.setSendBufferSize(0x400000);
        sessionConfig.setKeepAlive(true);
        sessionConfig.setSoLinger(0);
        sessionConfig.setTcpNoDelay(true);
        sessionConfig.setUseReadOperation(false);
        sessionConfig.setReuseAddress(true);
        InetSocketAddress socketAddress = new InetSocketAddress(this.serverPort);
        this.acceptor.bind((SocketAddress)socketAddress);
    }

    public void stop() throws IOException {
        this.acceptor.unbind();
    }
}

