/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.moProcess.queue;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class MOQueue<T>
implements InitializingBean {
    @Value(value="${cmppserver.moQueueSize}")
    private int moQueueSize;
    private BlockingQueue<T> queue;
    private BlockingQueue<T> backQueue;

    public void afterPropertiesSet() throws Exception {
        this.queue = new ArrayBlockingQueue<T>(this.moQueueSize);
        this.backQueue = new ArrayBlockingQueue<T>(this.moQueueSize);
    }

    public void put(T e) throws InterruptedException {
        this.queue.put(e);
    }

    public boolean offer(T e) {
        return this.queue.offer(e);
    }

    public T take() throws InterruptedException {
        Object ret = this.backQueue.poll();
        return (T)(ret != null ? ret : this.queue.take());
    }

    public int size() {
        return this.queue.size() + this.backQueue.size();
    }

    public int queueSize() {
        return this.queue.size();
    }

    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public void clear() {
        this.queue.clear();
        this.backQueue.clear();
    }

    public boolean putBack(T e) {
        return this.backQueue.offer(e);
    }
}

