/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.moProcess;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.moProcess.MoRetryTask;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;
import com.aspire.nm.component.cmppserver.util.MessageIdGenerator;
import com.aspire.nm.component.commonUtil.seq.SequenceGenerator;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class MoSender
extends ApplicationObjectSupport
implements InitializingBean,
Runnable {
    @Value(value="${cmppserver.moRetryTimeOut}")
    private int moRetryTimeOut;
    @Value(value="${cmppserver.maxDeliveryRetryHtSize}")
    private int maxDeliveryRetryHtSize;
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;
    private Thread t;
    private Connection connection;
    private Hashtable<Integer, TimerTask> deliveryRetryHt = new Hashtable();

    public Thread getT() {
        return this.t;
    }

    public void afterPropertiesSet() throws Exception {
        this.t = new Thread(this);
        this.t.start();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Hashtable<Integer, TimerTask> getDeliveryRetryHt() {
        return this.deliveryRetryHt;
    }

    @Override
    public void run() {
        SequenceGenerator seq = SequenceGenerator.getSequenceGenerator((long)1L, (long)Integer.MAX_VALUE);
        MessageIdGenerator msgIdGen = MessageIdGenerator.getMessageIdGenerator();
        Timer timer = new Timer();
        try {
            while (!this.t.isInterrupted() && !this.t.isInterrupted()) {
                if (this.connection == null) {
                    Thread.sleep(5000L);
                    continue;
                }
                if (this.connection.isMoConn()) {
                    long tmp;
                    if (this.deliveryRetryHt.size() >= this.maxDeliveryRetryHtSize) continue;
                    CmppDeliverPacket pk = this.connection.getUserRunTime().getmOQueue().take();
                    if (pk.autoDeliverSubmitTime != 0L && (tmp = System.currentTimeMillis() - pk.autoDeliverSubmitTime) < 1000L) {
                        Thread.sleep(1000L - tmp);
                    }
                    pk.setSequenceId(seq.nextInt());
                    pk.setMsgId(msgIdGen.getMsgId((short)0));
                    pk.setVersion(this.connection.getVersion());
                    MoRetryTask moRetryTask = (MoRetryTask)this.getApplicationContext().getBean(MoRetryTask.class);
                    moRetryTask.setmOSender(this);
                    moRetryTask.setPk(pk);
                    this.deliveryRetryHt.put(pk.getSequenceId(), moRetryTask);
                    timer.schedule((TimerTask)moRetryTask, this.moRetryTimeOut * 1000, (long)(this.moRetryTimeOut * 1000));
                    if (this.connection.getSession().isClosing()) {
                        throw new InterruptedException("Session is closed.");
                    }
                    if (pk.isSMSReport()) {
                        this.sysRunTimeService.getMoMtCounter().getReportCounter().increment();
                        this.connection.getUserRunTime().getMoMtCounter().getReportCounter().increment();
                        this.connection.getMoMtCounter().getReportCounter().increment();
                    } else {
                        this.sysRunTimeService.getMoMtCounter().getMoCounter().increment();
                        this.connection.getUserRunTime().getMoMtCounter().getReportCounter().increment();
                        this.connection.getMoMtCounter().getMoCounter().increment();
                    }
                    this.logService.deliver(this.connection.getUserRunTime().getUser(), pk);
                    this.connection.getSession().write((Object)pk);
                    InvokeRateUtil.invokeRate_send_deliver.count();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            timer.cancel();
        }
    }

    public boolean returnDelivery(CmppDeliverPacket delivery) {
        return this.connection.getUserRunTime().getmOQueue().putBack(delivery);
    }
}

