/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.moProcess;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.moProcess.MoSender;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;
import java.util.TimerTask;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class MoRetryTask
extends TimerTask {
    @Value(value="${cmppserver.maxMoRetryTimes}")
    private int maxMoRetryTimes;
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;
    private MoSender moSender;
    private CmppDeliverPacket pk;
    private int retryTimes;

    public MoSender getMoSender() {
        return this.moSender;
    }

    public void setmOSender(MoSender moSender) {
        this.moSender = moSender;
    }

    public CmppDeliverPacket getPk() {
        return this.pk;
    }

    public void setPk(CmppDeliverPacket pk) {
        this.pk = pk;
    }

    @Override
    public void run() {
        if (++this.retryTimes <= this.maxMoRetryTimes) {
            IoSession session = this.moSender.getConnection().getSession();
            if (!session.isClosing()) {
                if (this.pk.bizParams == null) {
                    this.pk.bizParams = "retryTimes=1";
                } else {
                    String s = (String)this.pk.bizParams;
                    int i = Integer.parseInt(s.substring(s.lastIndexOf("=") + 1)) + 1;
                    this.pk.bizParams = "retryTimes=" + i;
                }
                this.sysRunTimeService.setResendTimes(this.sysRunTimeService.getResendTimes() + 1);
                this.moSender.getConnection().setResendTimes(this.moSender.getConnection().getResendTimes() + 1);
                this.moSender.getConnection().getUserRunTime().setResendTimes(this.moSender.getConnection().getUserRunTime().getResendTimes() + 1);
                this.logService.deliver(this.moSender.getConnection().getUserRunTime().getUser(), this.pk);
                session.write((Object)this.pk);
                InvokeRateUtil.invokeRate_send_deliver.count();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
            this.moSender.getDeliveryRetryHt().remove(this.pk.getSequenceId());
        }
    }
}

