/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class SpeedCounter
extends Thread
implements InitializingBean {
    private AtomicLong count = new AtomicLong();
    private long countPerSec;
    private long preSecCount;

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public AtomicLong getCount() {
        return this.count;
    }

    public long getCountPerSec() {
        return this.countPerSec;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.countPerSec = this.count.get() - this.preSecCount;
            this.preSecCount = this.count.get();
        }
    }
}

