/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.counter;

import com.aspire.nm.component.cmppserver.runTime.counter.DailyCount;
import com.aspire.nm.component.cmppserver.runTime.counter.FailDetailCounter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class FailCounter
extends ApplicationObjectSupport {
    private long lastCountTimes;
    @Resource
    private DailyCount dailyCount;
    private AtomicLong count = new AtomicLong();
    private ConcurrentHashMap<String, FailDetailCounter> detailMap = new ConcurrentHashMap();

    public ConcurrentHashMap<String, FailDetailCounter> getDetailMap() {
        return this.detailMap;
    }

    public void increment(String detail) {
        this.count.incrementAndGet();
        this.dailyCount.increment();
        this.lastCountTimes = System.currentTimeMillis();
        if (this.detailMap.get(detail) == null) {
            this.detailMap.put(detail, (FailDetailCounter)this.getApplicationContext().getBean(FailDetailCounter.class));
        }
        this.detailMap.get(detail).increment();
    }

    public long getLastCountTimes() {
        return this.lastCountTimes;
    }

    public DailyCount getDailyCount() {
        return this.dailyCount;
    }

    public AtomicLong getCount() {
        return this.count;
    }
}

