/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class DailyCount
extends Thread
implements InitializingBean {
    private AtomicLong yesToDayCount = new AtomicLong();
    private AtomicLong count = new AtomicLong();

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    @Override
    public void run() {
        while (true) {
            try {
                DailyCount.sleep(this.getSleepMillis());
                DailyCount.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.yesToDayCount.set(this.count.get());
            this.count.set(0L);
        }
    }

    private long getSleepMillis() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, cal.get(11) + 1);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    public AtomicLong getYesToDayCount() {
        return this.yesToDayCount;
    }

    public AtomicLong getCount() {
        return this.count;
    }
}

