/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.SpeedController;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.cmppserver.runTime.moProcess.queue.MOQueue;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class UserRunTime
extends ApplicationObjectSupport {
    @Resource
    private LogService logService;
    @Resource
    private MOQueue<CmppDeliverPacket> mOQueue;
    @Resource
    private SpeedController speedController;
    @Resource
    private MoMtCounter moMtCounter;
    private int resendTimes;
    private String user;
    private ClientConfig clientConfig;
    private List<Connection> connections = new ArrayList<Connection>();

    public MOQueue<CmppDeliverPacket> getmOQueue() {
        return this.mOQueue;
    }

    public int getResendTimes() {
        return this.resendTimes;
    }

    public void setResendTimes(int resendTimes) {
        this.resendTimes = resendTimes;
    }

    public MoMtCounter getMoMtCounter() {
        return this.moMtCounter;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public String getUser() {
        return this.user;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void addSession(IoSession session, Version version) {
        Connection connection = (Connection)this.getApplicationContext().getBean(Connection.class);
        connection.setSession(session);
        connection.setVersion(version);
        connection.setUserRunTime(this);
        connection.getMoSender().setConnection(connection);
        this.connections.add(connection);
    }

    public boolean removeSession(IoSession session) {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (!this.connections.get(i).equals(session)) continue;
            this.connections.get(i).getMoSender().getT().interrupt();
            this.connections.remove(i);
            return true;
        }
        return false;
    }

    public int getConnNum() {
        return this.connections.size();
    }

    public boolean haveMoConn() {
        for (Connection connection : this.connections) {
            if (!connection.isMoConn()) continue;
            return true;
        }
        return false;
    }

    public Connection getConnection(IoSession session) {
        for (Connection connection : this.connections) {
            if (!connection.equals(session)) continue;
            return connection;
        }
        return null;
    }

    public boolean addMo(CmppDeliverPacket cmppDeliverPacket, boolean block) {
        int moLimitInSec;
        if (block && (moLimitInSec = this.clientConfig.getMoLimitInSec()) != 0) {
            this.speedController.isTimeLimitInSecond(moLimitInSec, true);
        }
        if (block) {
            try {
                this.mOQueue.put(cmppDeliverPacket);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (!this.mOQueue.offer(cmppDeliverPacket)) {
            return false;
        }
        InvokeRateUtil.invokeRate_add_deliver.count();
        return true;
    }
}

