/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.runTime.counter.ForbiddenCounter;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.commonUtil.date.DateUtil;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Service;

@Service
public class SysRunTimeService
extends ApplicationObjectSupport
implements InitializingBean {
    private String systemStartTime;
    @Resource
    private MoMtCounter moMtCounter;
    @Resource
    private ForbiddenCounter forBiddenIpCount;
    @Resource
    private ForbiddenCounter forbiddenCmppCount;
    private int resendTimes;
    private TreeMap<String, UserRunTime> userRunTimeHt = new TreeMap();
    private Hashtable<Long, UserRunTime> sessionIdRunTimeHt = new Hashtable();

    public void afterPropertiesSet() throws Exception {
        this.systemStartTime = DateUtil.getCurDateTime();
    }

    public int getResendTimes() {
        return this.resendTimes;
    }

    public void setResendTimes(int resendTimes) {
        this.resendTimes = resendTimes;
    }

    public String getSystemStartTime() {
        return this.systemStartTime;
    }

    public MoMtCounter getMoMtCounter() {
        return this.moMtCounter;
    }

    public ForbiddenCounter getForBiddenIpCount() {
        return this.forBiddenIpCount;
    }

    public void setForBiddenIpCount(ForbiddenCounter forBiddenIpCount) {
        this.forBiddenIpCount = forBiddenIpCount;
    }

    public ForbiddenCounter getForbiddenCmppCount() {
        return this.forbiddenCmppCount;
    }

    public void setForbiddenCmppCount(ForbiddenCounter forbiddenCmppCount) {
        this.forbiddenCmppCount = forbiddenCmppCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientConfig(String user, ClientConfig clientConfig) throws UnknownHostException {
        TreeMap<String, UserRunTime> treeMap = this.userRunTimeHt;
        synchronized (treeMap) {
            UserRunTime userRunTime = (UserRunTime)((Object)this.getApplicationContext().getBean(UserRunTime.class));
            userRunTime.setUser(user);
            userRunTime.setClientConfig(clientConfig);
            this.userRunTimeHt.put(user, userRunTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientConfig(String user) {
        TreeMap<String, UserRunTime> treeMap = this.userRunTimeHt;
        synchronized (treeMap) {
            UserRunTime usrRunTime = this.userRunTimeHt.get(user);
            if (usrRunTime != null) {
                Iterator<Connection> it = usrRunTime.getConnections().iterator();
                while (it.hasNext()) {
                    it.next().getSession().close(true);
                }
                this.userRunTimeHt.remove(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConfig getClientConfig(String user) {
        TreeMap<String, UserRunTime> treeMap = this.userRunTimeHt;
        synchronized (treeMap) {
            UserRunTime userRunTime = this.userRunTimeHt.get(user);
            if (userRunTime == null) {
                return null;
            }
            return userRunTime.getClientConfig();
        }
    }

    public void addSession(String user, IoSession session, Version version) {
        UserRunTime userRunTime = this.userRunTimeHt.get(user);
        if (userRunTime != null) {
            userRunTime.addSession(session, version);
            this.sessionIdRunTimeHt.put(session.getId(), userRunTime);
        }
    }

    public boolean removeSession(IoSession session) {
        UserRunTime userRunTime = this.sessionIdRunTimeHt.get(session.getId());
        if (userRunTime != null) {
            this.sessionIdRunTimeHt.remove(session.getId());
            return userRunTime.removeSession(session);
        }
        return false;
    }

    public TreeMap<String, UserRunTime> getUserRunTimeHt() {
        return this.userRunTimeHt;
    }

    public UserRunTime getUserRunTime(IoSession session) {
        return this.sessionIdRunTimeHt.get(session.getId());
    }

    public UserRunTime getUserRunTime(String user) {
        return this.userRunTimeHt.get(user);
    }

    public boolean isConnected(IoSession session) {
        if (this.sessionIdRunTimeHt.get(session.getId()) == null) {
            return false;
        }
        return this.sessionIdRunTimeHt.get(session.getId()).getConnNum() > 0;
    }
}

