/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.runTime;

import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.SpeedController;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.cmppserver.runTime.moProcess.MoSender;
import com.aspire.nm.component.commonUtil.date.DateUtil;
import java.net.InetSocketAddress;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component
public class Connection
implements InitializingBean {
    private String connStartTime;
    private long activeLastTime;
    @Resource
    private MoSender moSender;
    @Resource
    private MoMtCounter moMtCounter;
    @Resource
    private SpeedController mtSpeedController;
    private int resendTimes;
    private UserRunTime userRunTime;
    private IoSession session;
    private Version version;

    public void afterPropertiesSet() throws Exception {
        this.connStartTime = DateUtil.getCurDateTime();
    }

    public String getConnStartTime() {
        return this.connStartTime;
    }

    public long getActiveLastTime() {
        return this.activeLastTime;
    }

    public void setActiveLastTime() {
        this.activeLastTime = System.currentTimeMillis();
    }

    public int getResendTimes() {
        return this.resendTimes;
    }

    public void setResendTimes(int resendTimes) {
        this.resendTimes = resendTimes;
    }

    public MoSender getMoSender() {
        return this.moSender;
    }

    public MoMtCounter getMoMtCounter() {
        return this.moMtCounter;
    }

    public SpeedController getMtSpeedController() {
        return this.mtSpeedController;
    }

    public UserRunTime getUserRunTime() {
        return this.userRunTime;
    }

    public void setUserRunTime(UserRunTime userRunTime) {
        this.userRunTime = userRunTime;
    }

    public IoSession getSession() {
        return this.session;
    }

    public void setSession(IoSession session) {
        this.session = session;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String getId() {
        return ((InetSocketAddress)this.session.getRemoteAddress()).getAddress().toString() + ":" + ((InetSocketAddress)this.session.getRemoteAddress()).getPort();
    }

    public boolean isMoConn() {
        return this.version.getMinor() != 15;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IoSession) {
            return ((IoSession)obj).getId() == this.session.getId();
        }
        return false;
    }
}

