/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.handler;

import com.aspire.nm.component.cmppserver.CmppServer;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.handler.SubmitReqResp;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;
import com.aspire.nm.component.cmppserver.util.MessageIdGenerator;
import com.aspire.nm.component.commonUtil.date.DateUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessSubmitManager {
    @Resource
    private CmppServer cmppServer;
    @Resource(name="submitExecutor")
    private Executor submitExecutor;
    @Resource
    private SysRunTimeService sysRunTimeService;
    @Value(value="${cmppserver.splitSubmitMsg}")
    private boolean splitSubmitMsg;
    @Value(value="${cmppserver.syncProcessSubmit}")
    private boolean syncProcessSubmit;
    @Value(value="${autoDeliver}")
    private boolean autoDeliver;
    @Resource
    private LogService logService;

    public int process(IoSession session, CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket) {
        if (this.syncProcessSubmit) {
            return this.processSync(session, cmppSubmitPacket, cmppSubmitRespPacket);
        }
        return this.processAsync(session, cmppSubmitPacket, cmppSubmitRespPacket);
    }

    public int processAsync(IoSession session, CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket) {
        try {
            this.submitExecutor.execute(new Thread(){
                private CmppSubmitPacket cmppSubmitPacket;
                private CmppSubmitRespPacket cmppSubmitRespPacket;
                private IoSession session;

                public Runnable setParams(IoSession session, CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket) {
                    this.cmppSubmitPacket = cmppSubmitPacket;
                    this.cmppSubmitRespPacket = cmppSubmitRespPacket;
                    this.session = session;
                    return this;
                }

                @Override
                public void run() {
                    ProcessSubmitManager.this.processSync(this.session, this.cmppSubmitPacket, this.cmppSubmitRespPacket);
                }
            }.setParams(session, cmppSubmitPacket, cmppSubmitRespPacket));
        }
        catch (RejectedExecutionException re) {
            re.printStackTrace();
        }
        return CmppSubmitRespPacket.RESULT_OK;
    }

    private int processSync(IoSession session, CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket) {
        String clientIp = ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress();
        String user = this.sysRunTimeService.getUserRunTime(session).getUser();
        if (this.cmppServer.getProcessSubmit() != null) {
            if (this.splitSubmitMsg) {
                List<SubmitReqResp> submitReqResps = this.getSubmitReqResps(cmppSubmitPacket, cmppSubmitRespPacket, this.sysRunTimeService.getUserRunTime(session).getConnection(session).getVersion());
                int result = -1;
                for (SubmitReqResp submitReqResp : submitReqResps) {
                    this.logService.processSubmit(session, submitReqResp.cmppSubmitPacket);
                    int tmpresult = this.cmppServer.getProcessSubmit().process(submitReqResp.cmppSubmitPacket, submitReqResp.cmppSubmitRespPacket, user, clientIp);
                    if (result == -1) {
                        result = tmpresult;
                    }
                    if (tmpresult == CmppSubmitRespPacket.RESULT_OK) {
                        result = CmppSubmitRespPacket.RESULT_OK;
                    }
                    if (!this.autoDeliver || tmpresult != CmppSubmitRespPacket.RESULT_OK) continue;
                    this.autoDeliver(submitReqResp.cmppSubmitPacket, submitReqResp.cmppSubmitRespPacket, user, clientIp);
                }
                return result;
            }
            this.logService.processSubmit(session, cmppSubmitPacket);
            int result = this.cmppServer.getProcessSubmit().process(cmppSubmitPacket, cmppSubmitRespPacket, user, clientIp);
            if (this.autoDeliver && result == CmppSubmitRespPacket.RESULT_OK) {
                List<SubmitReqResp> submitReqResps = this.getSubmitReqResps(cmppSubmitPacket, cmppSubmitRespPacket, this.sysRunTimeService.getUserRunTime(session).getConnection(session).getVersion());
                for (SubmitReqResp submitReqResp : submitReqResps) {
                    this.autoDeliver(submitReqResp.cmppSubmitPacket, submitReqResp.cmppSubmitRespPacket, user, clientIp);
                }
            }
            return result;
        }
        return CmppSubmitRespPacket.RESULT_OK;
    }

    private void autoDeliver(CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket, String user, String clientIp) {
        CmppDeliverPacket cmppDeliverPacket = new CmppDeliverPacket();
        if (cmppSubmitPacket.getRegisteredDelivery() == 1) {
            cmppDeliverPacket.setDestId(cmppSubmitPacket.getSrcId());
            cmppDeliverPacket.setDestTerminalId(cmppSubmitPacket.getDestTerminateIds());
            cmppDeliverPacket.setRegisteredDelivery(true);
            cmppDeliverPacket.setSrcTerminalId(cmppSubmitPacket.getDestTerminateIds());
            cmppDeliverPacket.setSrcTerminalType((byte)0);
            cmppDeliverPacket.setServiceId(cmppSubmitPacket.getServiceId());
            cmppDeliverPacket.setMsgId(MessageIdGenerator.getMessageIdGenerator().getMsgId((short)0));
            cmppDeliverPacket.setIsmgMsgId(cmppSubmitRespPacket.getMsgId());
            cmppDeliverPacket.setStat("DELIVERD");
            cmppDeliverPacket.setSubmitTime(DateUtil.getCurDateTimeFormat((String)"yyMMddHHmm"));
            cmppDeliverPacket.setDoneTime(DateUtil.getCurDateTimeFormat((String)"yyMMddHHmm"));
            try {
                cmppDeliverPacket.setLinkId("linkid");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            cmppDeliverPacket.setMsgFmt((byte)15);
        } else {
            cmppDeliverPacket.setDestId(cmppSubmitPacket.getSrcId());
            cmppDeliverPacket.setDestTerminalId(cmppSubmitPacket.getDestTerminateIds());
            cmppDeliverPacket.setRegisteredDelivery(false);
            cmppDeliverPacket.setSrcTerminalId(cmppSubmitPacket.getDestTerminateIds());
            cmppDeliverPacket.setSrcTerminalType((byte)0);
            cmppDeliverPacket.setServiceId(cmppSubmitPacket.getServiceId());
            cmppDeliverPacket.setMsgContent(cmppSubmitPacket.getMsgContent());
            cmppDeliverPacket.setMsgId(MessageIdGenerator.getMessageIdGenerator().getMsgId((short)0));
            try {
                cmppDeliverPacket.setLinkId("linkid");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            cmppDeliverPacket.setMsgFmt((byte)15);
        }
        UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(user);
        if (userRunTime != null) {
            cmppDeliverPacket.autoDeliverSubmitTime = System.currentTimeMillis();
            if (!userRunTime.addMo(cmppDeliverPacket, false)) {
                InvokeRateUtil.invokeRate_auto_deliver_fail.count();
            }
        }
    }

    private List<SubmitReqResp> getSubmitReqResps(CmppSubmitPacket cmppSubmitPacket, CmppSubmitRespPacket cmppSubmitRespPacket, Version version) {
        String[] terminals = cmppSubmitPacket.getDestTerminalId();
        long msgId = cmppSubmitRespPacket.getMsgId();
        int index = 0;
        ArrayList<SubmitReqResp> submitReqResps = new ArrayList<SubmitReqResp>();
        for (String terminal : terminals) {
            CmppSubmitPacket cmppSubmitPacketSingle = new CmppSubmitPacket(version);
            BeanUtils.copyProperties((Object)cmppSubmitPacket, (Object)cmppSubmitPacketSingle);
            cmppSubmitPacketSingle.setDestTerminalId(new String[]{terminal});
            CmppSubmitRespPacket cmppSubmitRespPacketSingle = new CmppSubmitRespPacket(version);
            cmppSubmitRespPacketSingle.setMsgId(msgId + (long)index);
            ++index;
            submitReqResps.add(new SubmitReqResp(cmppSubmitPacketSingle, cmppSubmitRespPacketSingle));
        }
        return submitReqResps;
    }
}

