/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.handler;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppTerminatePacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppTerminateRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.handler.ProcessSubmitManager;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;
import com.aspire.nm.component.cmppserver.util.MessageIdGenerator;
import com.aspire.nm.component.cmppserver.validate.CmppConnectAuthenticator;
import com.aspire.nm.component.cmppserver.validate.CmppSubmitPacketCheck;
import com.aspire.nm.component.commonUtil.secret.secret.SecretUtil;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.TimerTask;
import javax.annotation.Resource;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.springframework.stereotype.Service;

@Service
public class EventHandler
extends IoHandlerAdapter {
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;
    @Resource
    private CmppConnectAuthenticator cmppConnectAuthenticator;
    @Resource
    private CmppSubmitPacketCheck cmppSubmitPacketCheck;
    @Resource
    private ProcessSubmitManager processSubmitManager;

    public void messageReceived(IoSession session, Object message) throws Exception {
        CmppPacket resp;
        if (message instanceof CmppConnectPacket) {
            resp = this.processCmppConnectPacket(session, (CmppConnectPacket)message);
            session.write((Object)resp);
        }
        if (message instanceof CmppSubmitPacket) {
            InvokeRateUtil.invokeRate_receive_submit.count();
            CmppSubmitPacket req = (CmppSubmitPacket)message;
            this.logService.submit(session, req);
            CmppSubmitRespPacket resp2 = this.receivedCmppSubmitPacket(session, req);
            if (resp2.getResult() == CmppSubmitRespPacket.RESULT_OK) {
                resp2.setResult(this.processSubmitManager.process(session, req, resp2));
            }
            session.write((Object)resp2);
            InvokeRateUtil.invokeRate_send_submitresp.count();
            this.logService.submitResp(session, resp2);
        }
        if (message instanceof CmppDeliverRespPacket) {
            InvokeRateUtil.invokeRate_receive_deliverresp.count();
            this.logService.deliverResp(session, (CmppDeliverRespPacket)message);
            this.receivedCmppDeliverRespPacket(session, (CmppDeliverRespPacket)message);
        }
        if (message instanceof CmppTerminatePacket) {
            this.logService.terminate(session, (CmppTerminatePacket)message);
            resp = this.receivedCmppTerminatePacket(session, (CmppTerminatePacket)message);
            this.logService.terminateResp(session, (CmppTerminateRespPacket)resp);
            session.write((Object)resp);
        }
        if (message instanceof CmppTerminateRespPacket) {
            this.logService.terminateResp(session, (CmppTerminateRespPacket)message);
            this.receivedCmppTerminateRespPacket(session, (CmppTerminateRespPacket)message);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.logService.throwAble(session, cause);
    }

    private CmppPacket processCmppConnectPacket(IoSession session, CmppConnectPacket cmppConnectPacket) {
        int stat = this.cmppConnectAuthenticator.auth(cmppConnectPacket.getSourceAddr(), cmppConnectPacket.getAuthenticatorSource(), ((InetSocketAddress)session.getRemoteAddress()).getAddress().getHostAddress(), cmppConnectPacket.getTimestamp());
        byte[] authenticatorISMG = new byte[16];
        if (stat == 0) {
            String authISMG = stat + new String(cmppConnectPacket.getAuthenticatorSource()) + this.sysRunTimeService.getClientConfig(cmppConnectPacket.getSourceAddr()).getPass();
            authenticatorISMG = SecretUtil.ToMd5((byte[])authISMG.getBytes());
        }
        CmppConnectRespPacket cmppConnectRespPacket = new CmppConnectRespPacket(cmppConnectPacket.getVersion());
        cmppConnectRespPacket.setSequenceId(cmppConnectPacket.getSequenceId());
        cmppConnectRespPacket.setStatus(stat);
        cmppConnectRespPacket.setAuthenticatorISMG(authenticatorISMG);
        cmppConnectRespPacket.bizParams = cmppConnectPacket;
        return cmppConnectRespPacket;
    }

    private CmppSubmitRespPacket receivedCmppSubmitPacket(IoSession session, CmppSubmitPacket cmppSubmitPacket) {
        Version version = this.sysRunTimeService.getUserRunTime(session).getConnection(session).getVersion();
        int len = cmppSubmitPacket.getDestTerminalId().length;
        long msgId = MessageIdGenerator.getMessageIdGenerator().getMsgId((short)len);
        int status = this.cmppSubmitPacketCheck.check(cmppSubmitPacket, session, version);
        CmppSubmitRespPacket resp = new CmppSubmitRespPacket(version);
        resp.setSequenceId(cmppSubmitPacket.getSequenceId());
        resp.setMsgId(msgId);
        resp.setResult(status);
        return resp;
    }

    private void receivedCmppDeliverRespPacket(IoSession session, CmppDeliverRespPacket cmppDeliverRespPacket) {
        Hashtable<Integer, TimerTask> deliverRetryHt = this.sysRunTimeService.getUserRunTime(session).getConnection(session).getMoSender().getDeliveryRetryHt();
        TimerTask task = deliverRetryHt.remove(cmppDeliverRespPacket.getSequenceId());
        if (task != null) {
            task.cancel();
        }
    }

    private CmppPacket receivedCmppTerminatePacket(IoSession session, CmppTerminatePacket cmppTerminatePacket) {
        CmppTerminateRespPacket resp = new CmppTerminateRespPacket();
        resp.setSequenceId(cmppTerminatePacket.getSequenceId());
        return resp;
    }

    private void receivedCmppTerminateRespPacket(IoSession session, CmppTerminateRespPacket cmppTerminateRespPacket) {
    }
}

