/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.keepAlive;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestRespPacket;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.util.LogService;
import com.aspire.nm.component.commonUtil.seq.SequenceGenerator;
import javax.annotation.Resource;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.keepalive.KeepAliveMessageFactory;
import org.springframework.stereotype.Service;

@Service
public class KeepAliveMessage
implements KeepAliveMessageFactory {
    private SequenceGenerator seq = SequenceGenerator.getSequenceGenerator((long)1L, (long)Integer.MAX_VALUE);
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;

    public boolean isRequest(IoSession session, Object message) {
        return message instanceof CmppActiveTestPacket;
    }

    public boolean isResponse(IoSession session, Object message) {
        if (message instanceof CmppActiveTestRespPacket) {
            if (((CmppActiveTestRespPacket)message).bizParams != null) {
                this.setActiveLastTime(session);
                this.logService.activeToResp(session, (CmppActiveTestRespPacket)message);
            }
            return true;
        }
        return false;
    }

    public Object getRequest(IoSession session) {
        CmppActiveTestPacket cmppActiveTestPacket = new CmppActiveTestPacket();
        cmppActiveTestPacket.setSequenceId(this.seq.nextInt());
        this.logService.activeTo(session, cmppActiveTestPacket);
        return cmppActiveTestPacket;
    }

    public Object getResponse(IoSession session, Object request) {
        this.setActiveLastTime(session);
        this.logService.activeFrom(session, (CmppActiveTestPacket)request);
        CmppActiveTestRespPacket cmppActiveTestRespPacket = new CmppActiveTestRespPacket();
        cmppActiveTestRespPacket.setSequenceId(((CmppActiveTestPacket)request).getSequenceId());
        cmppActiveTestRespPacket.setReserved((byte)0);
        this.logService.activeFromResp(session, cmppActiveTestRespPacket);
        return cmppActiveTestRespPacket;
    }

    private void setActiveLastTime(IoSession session) {
        Connection connection;
        UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(session);
        if (userRunTime != null && (connection = userRunTime.getConnection(session)) != null) {
            connection.setActiveLastTime();
        }
    }
}

