/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.io.Serializable;

public class Version
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte major;
    private byte minor;
    private byte version;
    private String description;
    public static Version CMPP2_0_VERSION = new Version(32, "CMPP v2.0 MOMT");
    public static Version CMPP2_0_VERSION_1 = new Version(20, "CMPP v2.0 MOMT[ver=20]");
    public static Version CMPP2_0_VERSION_MO = new Version(46, "CMPP v2.0 MO");
    public static Version CMPP2_0_VERSION_MT = new Version(47, "CMPP v2.0 MT");
    public static Version CMPP3_0_VERSION = new Version(48, "CMPP v3.0 MOMT");
    public static Version CMPP3_0_VERSION_1 = new Version(30, "CMPP v3.0 MOMT[ver=30]");
    public static Version CMPP3_0_VERSION_MO = new Version(62, "CMPP v3.0 MO");
    public static Version CMPP3_0_VERSION_MO_1 = new Version(1, "CMPP v3.0 MO[ver=1]");
    public static Version CMPP3_0_VERSION_MT = new Version(63, "CMPP v3.0 MT");
    public static Version CMPP3_0_VERSION_MT_1 = new Version(0, "CMPP v3.0 MT[ver=0]");
    public static Version USMP4_0_VERSION = new Version(64, "USMP v4.0 PUSH");
    public static Version UNKNOW_VERSION = new Version(-1, "UNKNOW_VERSION");

    public Version(byte v, String desc) {
        this.version = v;
        this.major = (byte)((v & 0xF0) >> 4);
        this.minor = (byte)(v & 0xF);
        this.description = desc;
    }

    public Version(byte major, byte minor, String desc) {
        this.major = (byte)(major & 0xF);
        this.minor = (byte)(minor & 0xF);
        this.version = (byte)((major << 4) + minor);
        this.description = desc;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        return this.version == ((Version)obj).version;
    }

    public boolean isLarge(Version v) {
        return this.version > v.version;
    }

    public boolean isLittle(Version v) {
        return this.version < v.version;
    }

    public static Version toVersion(int ver) {
        Version version = UNKNOW_VERSION;
        version = ver == CMPP2_0_VERSION.getVersion() ? CMPP2_0_VERSION : (ver == CMPP2_0_VERSION_1.getVersion() ? CMPP2_0_VERSION_1 : (ver == CMPP2_0_VERSION_MO.getVersion() ? CMPP2_0_VERSION_MO : (ver == CMPP2_0_VERSION_MT.getVersion() ? CMPP2_0_VERSION_MT : (ver == CMPP3_0_VERSION.getVersion() ? CMPP3_0_VERSION : (ver == CMPP3_0_VERSION_1.getVersion() ? CMPP3_0_VERSION_1 : (ver == CMPP3_0_VERSION_MO.getVersion() ? CMPP3_0_VERSION_MO : (ver == CMPP3_0_VERSION_MT.getVersion() ? CMPP3_0_VERSION_MT : (ver == USMP4_0_VERSION.getVersion() ? USMP4_0_VERSION : (ver == CMPP3_0_VERSION_MO_1.getVersion() ? CMPP3_0_VERSION_MO : (ver == CMPP3_0_VERSION_MT_1.getVersion() ? CMPP3_0_VERSION_MT : UNKNOW_VERSION))))))))));
        return version;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean isSingleMOVersion() {
        return this.minor == 14 && this.version != 30;
    }

    public boolean isSingleMTVersion() {
        return this.minor == 15;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isVersion3() {
        return this.major == Version.CMPP3_0_VERSION.major || this.version == Version.CMPP3_0_VERSION_1.version;
    }

    public boolean isVersion2() {
        return this.major == Version.CMPP2_0_VERSION.major || this.version == Version.CMPP2_0_VERSION_1.version;
    }

    public boolean isVersion4() {
        return this.major == Version.USMP4_0_VERSION.major;
    }

    public String toString() {
        return this.getDescription();
    }
}

