/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import java.nio.ByteBuffer;

public class Packet {
    private ByteBuffer buffer;

    public Packet() {
    }

    public Packet(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    public Packet(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public byte[] getBytes() {
        return this.buffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    protected ByteBuffer allocate(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
        return this.buffer;
    }

    protected void setBytes(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    protected void setByteBuffer(ByteBuffer bytes) {
        this.buffer = bytes;
    }

    protected ByteBuffer put(byte b) {
        return this.buffer.put(b);
    }

    protected ByteBuffer put(byte[] src) {
        return this.buffer.put(src);
    }

    protected ByteBuffer put(byte[] src, int offset, int length) {
        return this.buffer.put(src, offset, length);
    }

    protected ByteBuffer put(ByteBuffer src) {
        return this.buffer.put(src);
    }

    protected ByteBuffer put(int index, byte b) {
        return this.buffer.put(index, b);
    }

    protected ByteBuffer putChar(char value) {
        return this.buffer.putChar(value);
    }

    protected ByteBuffer putChar(int index, char value) {
        return this.buffer.putChar(index, value);
    }

    protected ByteBuffer putDouble(double value) {
        return this.buffer.putDouble(value);
    }

    protected ByteBuffer putDouble(int index, double value) {
        return this.buffer.putDouble(index, value);
    }

    protected ByteBuffer putFloat(float value) {
        return this.buffer.putFloat(value);
    }

    protected ByteBuffer putFloat(int index, float value) {
        return this.buffer.putFloat(index, value);
    }

    protected ByteBuffer putInt(int value) {
        return this.buffer.putInt(value);
    }

    protected ByteBuffer putInt(int index, int value) {
        return this.buffer.putInt(index, value);
    }

    protected ByteBuffer putLong(long value) {
        return this.buffer.putLong(value);
    }

    protected ByteBuffer putLong(int index, long value) {
        return this.buffer.putLong(index, value);
    }

    protected ByteBuffer putShort(short value) {
        return this.buffer.putShort(value);
    }

    protected ByteBuffer putShort(int index, short value) {
        return this.buffer.putShort(index, value);
    }

    protected ByteBuffer putString(String value) {
        return this.buffer.put(value.getBytes());
    }

    protected ByteBuffer putString(String value, int beginIndex, int endIndex) {
        return this.buffer.put(value.substring(beginIndex, endIndex).getBytes());
    }

    protected ByteBuffer putStringLeftPad(String value, int len) {
        int add;
        if (len <= 0) {
            return this.buffer;
        }
        int n = value == null ? len : (add = len <= value.length() ? 0 : value.length() - len);
        if (add == 0) {
            this.buffer.put(value.getBytes(), 0, len);
        } else if (add == len) {
            this.buffer.put(new byte[len]);
        } else {
            this.buffer.put(new byte[add]);
            this.buffer.put(value.getBytes());
        }
        return this.buffer;
    }

    protected ByteBuffer putStringRightPad(String value, int len) {
        int add;
        if (len <= 0) {
            return this.buffer;
        }
        int n = value == null ? len : (add = len <= value.length() ? 0 : len - value.length());
        if (add == 0) {
            this.buffer.put(value.getBytes(), 0, len);
        } else if (add == len) {
            this.buffer.put(new byte[len]);
        } else {
            this.buffer.put(value.getBytes());
            this.buffer.put(new byte[add]);
        }
        return this.buffer;
    }

    protected byte get() {
        return this.buffer.get();
    }

    protected ByteBuffer get(byte[] desc) {
        return this.buffer.get(desc);
    }

    protected ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buffer.get(dst, offset, length);
    }

    protected byte get(int index) {
        return this.buffer.get(index);
    }

    protected char getChar() {
        return this.buffer.getChar();
    }

    protected char getChar(int index) {
        return this.buffer.getChar(index);
    }

    protected double getDouble() {
        return this.buffer.getDouble();
    }

    protected double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    protected float getFloat() {
        return this.buffer.getFloat();
    }

    protected float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    protected int getInt() {
        return this.buffer.getInt();
    }

    protected int getInt(int index) {
        return this.buffer.getInt(index);
    }

    protected long getLong() {
        return this.buffer.getLong();
    }

    protected long getLong(int index) {
        return this.buffer.getLong(index);
    }

    protected short getShort() {
        return this.buffer.getShort();
    }

    protected short getShort(int index) {
        return this.buffer.getShort(index);
    }

    protected String getString(int length) {
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        String tmp = new String(bytes);
        int index = tmp.indexOf(0);
        if (index != -1) {
            tmp = tmp.substring(0, index);
        }
        return tmp;
    }
}

