/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;

public class CmppSubmitRespPacket
extends CmppPacket {
    private static final long serialVersionUID = 1L;
    public static Map<Integer, String> FailDetailMap = new Hashtable<Integer, String>();
    public static int RESULT_OK = 0;
    public static int RESULT_FEETYPE_ERR = 1;
    public static int RESULT_MSG_LENGTH_ERR = 4;
    public static int RESULT_FEE_CODE_ERR = 5;
    public static int RESULT_MSG_TOO_LONG = 6;
    public static int RESULT_SERVICE_ID_ERR = 7;
    public static int RESULT_SECONDLIMIT_ERR = 8;
    public static int RESULT_MINLIMIT_ERR = 18;
    public static int RESULT_HOURLIMIT_ERR = 28;
    public static int RESULT_DAYLIMIT_ERR = 38;
    public static int RESULT_SRC_ID_ERR = 10;
    public static int RESULT_DEST_TERMINAL_ID_ERR = 13;
    public static int RESULT_REJECT = 14;
    public static int RESULT_FILTER_KEYWORD = 15;
    public static int RESULT_DEST_TERMINAL_ID_WHILE_ERR = 17;
    public static int RESULT_DEST_TERMINAL_ID_BLACK_ERR = 18;
    private long msgId;
    private int result;

    public CmppSubmitRespPacket(Version version) {
        super(version);
        this.commandId = -2147483644;
        this.totalLength = version.isVersion3() ? 24 : 21;
    }

    @Override
    public byte[] pack() throws PacketException {
        super.pack();
        try {
            this.putLong(this.msgId);
            if (this.version.isVersion3()) {
                this.putInt(this.result);
            } else if (this.version.isVersion2()) {
                this.put((byte)this.result);
            }
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppSubmitRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        try {
            this.msgId = this.getLong();
            this.result = this.getInt();
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on unpacking CmppSubmitRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPP_SUBMIT_RESP:");
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(", Msg_Id=").append(this.msgId);
        sb.append(", Result=").append(this.result);
        return sb.toString();
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    static {
        FailDetailMap.put(RESULT_FEETYPE_ERR, "feeType\u9519\u8bef");
        FailDetailMap.put(RESULT_MSG_LENGTH_ERR, "\u6d88\u606f\u957f\u5ea6\u9519\u8bef");
        FailDetailMap.put(RESULT_FEE_CODE_ERR, "feeCode\u9519\u8bef");
        FailDetailMap.put(RESULT_MSG_TOO_LONG, "\u6d88\u606f\u8fc7\u957f");
        FailDetailMap.put(RESULT_SERVICE_ID_ERR, "serviceId\u9519\u8bef");
        FailDetailMap.put(RESULT_SECONDLIMIT_ERR, "\u6bcf\u79d2\u53d1\u9001\u8d85\u8fc7\u9600\u503c\u9519\u8bef");
        FailDetailMap.put(RESULT_DAYLIMIT_ERR, "\u5f53\u65e5\u53d1\u9001\u8d85\u8fc7\u9600\u503c\u9519\u8bef");
        FailDetailMap.put(RESULT_SRC_ID_ERR, "srcid\u9519\u8bef");
        FailDetailMap.put(RESULT_DEST_TERMINAL_ID_ERR, "destTerminalId\u9519\u8bef");
        FailDetailMap.put(RESULT_REJECT, "\u4f7f\u7528\u4e0a\u884c\u8fde\u63a5\u53d1\u9001\u4e0b\u884c\u9519\u8bef");
        FailDetailMap.put(RESULT_FILTER_KEYWORD, "\u542b\u6709\u5173\u952e\u5b57\u88ab\u8fc7\u6ee4");
        FailDetailMap.put(RESULT_DEST_TERMINAL_ID_WHILE_ERR, "\u975e\u767d\u540d\u5355\u9519\u8bef");
        FailDetailMap.put(RESULT_DEST_TERMINAL_ID_BLACK_ERR, "\u9ed1\u540d\u5355\u9519\u8bef");
    }
}

