/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.commonUtil.bytes.BytesUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class CmppSubmitPacket
extends CmppPacket {
    private static final long serialVersionUID = 1L;
    public static final int REGISTERED_DILIVERY_YES = 1;
    public static final int REGISTERED_DELIVERY_NO = 0;
    public static final int FEE_USR_TYPE_DEST_MSISDN = 0;
    public static final int FEE_USR_TYPE_SRC_MSISDN = 1;
    public static final int FEE_USR_TYPE_SP = 2;
    public static final int FEE_USR_TYPE_TERMINAL = 3;
    public static final int FEE_TERMINAL_TYPE_REAL = 0;
    public static final int FEE_TERMINAL_TYPE_MOCK = 1;
    public static final int MSG_FMT_ASCII = 0;
    public static final int MSG_FMT_WRITE_CARD = 3;
    public static final int MSG_FMT_BINARY = 4;
    public static final int MSG_FMT_UCS2 = 8;
    public static final int MSG_FMT_GBK = 15;
    public static final int MSG_FMT_FLASH = 24;
    public static final String FEE_TYPE_FREE = "01";
    private long msgId;
    private int pkTotal;
    private int pkNumber;
    private byte registeredDelivery;
    private byte msgLevel;
    private String serviceId;
    private byte feeUserType;
    private String feeTerminalId;
    private byte feeTerminalType;
    private byte tpPid;
    private byte tpUdhi;
    private byte msgFmt;
    private String msgSrc;
    private String feeType;
    private String feeCode;
    private String validTime;
    private String atTime;
    private String srcId;
    private byte destUsrTl;
    private String[] destTerminalId;
    private byte destTerminalType;
    private int msgLength;
    private byte[] msgContent;
    private String linkId;

    public CmppSubmitPacket(Version version) {
        super(version);
        this.commandId = 4;
    }

    @Override
    public byte[] pack() throws PacketException {
        int mainLength = this.version.isVersion3() ? 151 : 126;
        this.msgLength = this.msgContent.length;
        int destTerminalIdLength = this.destTerminalId.length * (this.version.isVersion3() ? 32 : 21);
        this.totalLength = 12 + mainLength + this.msgLength + destTerminalIdLength;
        super.pack();
        try {
            this.putLong(this.msgId);
            this.put((byte)this.pkTotal);
            this.put((byte)this.pkNumber);
            this.put(this.registeredDelivery);
            this.put(this.msgLevel);
            this.putStringRightPad(this.serviceId, 10);
            this.put(this.feeUserType);
            this.putStringRightPad(this.feeTerminalId, this.version.isVersion3() ? 32 : 21);
            if (this.version.isVersion3()) {
                this.put(this.feeTerminalType);
            }
            this.put(this.tpPid);
            this.put(this.tpUdhi);
            this.put(this.msgFmt);
            this.putStringRightPad(this.msgSrc, 6);
            this.putStringRightPad(this.feeType, 2);
            this.putStringRightPad(this.feeCode, 6);
            this.putStringRightPad(this.validTime, 17);
            this.putStringRightPad(this.atTime, 17);
            this.putStringRightPad(this.srcId, 21);
            this.put(this.destUsrTl);
            for (int i = 0; i < this.destUsrTl; ++i) {
                this.putStringRightPad(this.destTerminalId[i], this.version.isVersion3() ? 32 : 21);
            }
            if (this.version.isVersion3()) {
                this.put(this.destTerminalType);
            }
            this.put((byte)this.msgLength);
            this.put(this.msgContent);
            this.putStringRightPad(this.linkId, this.version.isVersion3() ? 20 : 8);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppSubmitPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId + ", Version=" + this.version + ",byteBufferSize=" + this.getByteBuffer().capacity() + ",byteBufferPosion=" + this.getByteBuffer().position() + ",byteBufferRemain=" + this.getByteBuffer().remaining() + ",linkId=" + this.linkId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        try {
            this.msgId = this.getLong();
            this.pkTotal = this.get();
            this.pkNumber = this.get();
            this.registeredDelivery = this.get();
            this.msgLevel = this.get();
            this.serviceId = this.getString(10);
            this.feeUserType = this.get();
            this.feeTerminalId = this.getString(this.version.isVersion3() ? 32 : 21);
            if (this.version.isVersion3()) {
                this.feeTerminalType = this.get();
            }
            this.tpPid = this.get();
            this.tpUdhi = this.get();
            this.msgFmt = this.get();
            this.msgSrc = this.getString(6);
            this.feeType = this.getString(2);
            this.feeCode = this.getString(6);
            this.validTime = this.getString(17);
            this.atTime = this.getString(17);
            this.srcId = this.getString(21);
            this.destUsrTl = this.get();
            this.destTerminalId = new String[this.destUsrTl];
            for (int i = 0; i < this.destUsrTl; ++i) {
                this.destTerminalId[i] = this.getString(this.version.isVersion3() ? 32 : 21);
            }
            if (this.version.isVersion3()) {
                this.destTerminalType = this.get();
            }
            this.msgLength = this.get();
            if (this.msgLength < 0) {
                this.msgLength += 256;
            }
            this.msgContent = new byte[this.msgLength];
            this.get(this.msgContent);
            this.linkId = this.getString(this.version.isVersion3() ? 20 : 8);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on unpacking CmppSubmitPacket:Version=" + this.version + " TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getPkTotal() {
        return this.pkTotal;
    }

    public void setPkTotal(int pkTotal) {
        this.pkTotal = pkTotal;
    }

    public int getPkNumber() {
        return this.pkNumber;
    }

    public void setPkNumber(int pkNumber) {
        this.pkNumber = pkNumber;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public byte getMsgLevel() {
        return this.msgLevel;
    }

    public void setMsgLevel(byte msgLevel) {
        this.msgLevel = msgLevel;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public byte getFeeUserType() {
        return this.feeUserType;
    }

    public void setFeeUserType(byte feeUserType) {
        this.feeUserType = feeUserType;
    }

    public String getFeeTerminalId() {
        return this.feeTerminalId;
    }

    public void setFeeTerminalId(String feeTerminalId) {
        this.feeTerminalId = feeTerminalId;
    }

    public byte getFeeTerminalType() {
        return this.feeTerminalType;
    }

    public void setFeeTerminalType(byte feeTerminalType) {
        this.feeTerminalType = feeTerminalType;
    }

    public byte getTpPid() {
        return this.tpPid;
    }

    public void setTpPid(byte tpPid) {
        this.tpPid = tpPid;
    }

    public byte getTpUdhi() {
        return this.tpUdhi;
    }

    public void setTpUdhi(byte tpUdhi) {
        this.tpUdhi = tpUdhi;
    }

    public byte getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(byte msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getMsgSrc() {
        return this.msgSrc;
    }

    public void setMsgSrc(String msgSrc) {
        this.msgSrc = msgSrc;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeCode() {
        return this.feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getValidTime() {
        return this.validTime;
    }

    public void setValidTime(String validTime) {
        this.validTime = validTime;
    }

    public String getAtTime() {
        return this.atTime;
    }

    public void setAtTime(String atTime) {
        this.atTime = atTime;
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public byte getDestUsrTl() {
        return this.destUsrTl;
    }

    public void setDestUsrTl(byte destUserTl) {
        this.destUsrTl = destUserTl;
    }

    public String[] getDestTerminalId() {
        return this.destTerminalId;
    }

    public void setDestTerminalId(String[] destTerminalId) {
        this.destTerminalId = destTerminalId;
    }

    public String getDestTerminateIds() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.destTerminalId.length; ++i) {
            sb.append(this.destTerminalId[i]).append(i == this.destTerminalId.length - 1 ? "" : ",");
        }
        return sb.toString();
    }

    public byte getDestTerminalType() {
        return this.destTerminalType;
    }

    public void setDestTerminalType(byte destTerminalType) {
        this.destTerminalType = destTerminalType;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int msgLength) {
        this.msgLength = msgLength;
    }

    public byte[] getMsgContent() {
        return this.msgContent;
    }

    private String getLongSmsPkMsg() {
        if (this.msgContent[0] == 5) {
            byte[] ret = new byte[]{0, this.msgContent[3]};
            return BytesUtil.bytes2hex((byte[])ret);
        }
        if (this.msgContent[0] == 6) {
            byte[] ret = new byte[2];
            System.arraycopy(this.msgContent, 3, ret, 0, 2);
            return BytesUtil.bytes2hex((byte[])ret);
        }
        return null;
    }

    public String getLongPartKey() {
        String longSmsPkMsg = this.getLongSmsPkMsg();
        if (longSmsPkMsg == null) {
            return "";
        }
        return this.getDestTerminateIds() + "_" + longSmsPkMsg + "_" + this.getPkNumber() + "_" + this.getPkTotal();
    }

    public String getMsgContentDecoded() {
        String ret = null;
        try {
            switch (this.msgFmt) {
                case 0: {
                    ret = new String(this.msgContent, "US-ASCII");
                    break;
                }
                case 4: {
                    ret = BytesUtil.bytes2hex((byte[])this.msgContent);
                    break;
                }
                case 8: 
                case 24: {
                    byte longSmsFirstByte = this.msgContent[0];
                    byte[] contentBytes = new byte[this.msgContent.length - (longSmsFirstByte + 1)];
                    System.arraycopy(this.msgContent, longSmsFirstByte + 1, contentBytes, 0, contentBytes.length);
                    byte[] tmpHeader = new byte[longSmsFirstByte + 1];
                    System.arraycopy(this.msgContent, 0, tmpHeader, 0, tmpHeader.length);
                    ret = new String(contentBytes, "UTF-16BE");
                    break;
                }
                case 15: {
                    ret = new String(this.msgContent, "GBK");
                    break;
                }
                default: {
                    ret = new String(this.msgContent);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            ret = new String(this.msgContent);
        }
        return ret;
    }

    public void setMsgContent(byte[] msgContent) {
        this.msgContent = msgContent;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getReserve() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public void setReserve(String reserve) {
        this.linkId = reserve;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPP_SUBMIT:");
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(", Msg_Id=").append(this.msgId);
        sb.append(", Pk_total=").append(this.pkTotal);
        sb.append(", Pk_number=").append(this.pkNumber);
        sb.append(", Registered_Delivery=").append(this.registeredDelivery);
        sb.append(", Msg_level=").append(this.msgLevel);
        sb.append(", Service_Id=").append(this.serviceId);
        sb.append(", Fee_UserType=").append(this.feeUserType);
        sb.append(", Fee_terminal_Id=").append(this.feeTerminalId);
        sb.append(", Fee_terminal_type=").append(this.feeTerminalType);
        sb.append(", TP_pId=").append(this.tpPid);
        sb.append(", TP_udhi=").append(this.tpUdhi);
        sb.append(", Msg_Fmt=").append(this.msgFmt);
        sb.append(", Msg_src=").append(this.msgSrc);
        sb.append(", FeeType=").append(this.feeType);
        sb.append(", FeeCode=").append(this.feeCode);
        sb.append(", ValId_Time=").append(this.validTime);
        sb.append(", At_Time=").append(this.atTime);
        sb.append(", Src_Id=").append(this.srcId);
        sb.append(", DestUsr_tl=").append(this.destUsrTl);
        sb.append(", Dest_terminal_Id=").append(this.getDestTerminateIds());
        sb.append(", Dest_terminal_type=").append(this.destTerminalType);
        sb.append(", Msg_Length=").append(this.msgLength);
        sb.append(", Msg_Content=").append(this.getMsgContentDecoded());
        sb.append(", LinkID=").append(this.linkId);
        sb.append(", LongPartKey=").append(this.getLongPartKey());
        return sb.toString();
    }
}

