/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.Packet;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class CmppPacket
extends Packet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Object bizParams;
    public static final int CMPP_CONNECT = 1;
    public static final int CMPP_CONNECT_LENGTH = 39;
    public static final int CMPP_CONNECT_RESP = -2147483647;
    public static final int CMPP_CONNECT_RESP_LENGTH_V30 = 33;
    public static final int CMPP_CONNECT_RESP_LENGTH_V20 = 30;
    public static final int CMPP_TERMINATE = 2;
    public static final int CMPP_TERMINATE_LENGTH = 12;
    public static final int CMPP_TERMINATE_RESP = -2147483646;
    public static final int CMPP_TERMINATE_RESP_LENGTH = 12;
    public static final int CMPP_SUBMIT = 4;
    public static final int CMPP_SUBMIT_LENGTH_MIN_V30 = 163;
    public static final int CMPP_SUBMIT_LENGTH_MIN_V20 = 136;
    public static final int CMPP_SUBMIT_RESP = -2147483644;
    public static final int CMPP_SUBMIT_RESP_LENGTH_V30 = 24;
    public static final int CMPP_SUBMIT_RESP_LENGTH_V20 = 21;
    public static final int CMPP_DELIVER = 5;
    public static final int CMPP_DELIVER_LENGTH_MIN_V30 = 109;
    public static final int CMPP_DELIVER_LENGTH_MIN_V20 = 85;
    public static final int CMPP_DELIVER_RESP = -2147483643;
    public static final int CMPP_DELIVER_RESP_LENGTH_V30 = 24;
    public static final int CMPP_DELIVER_RESP_LENGTH_V20 = 21;
    public static final int CMPP_QUERY = 6;
    public static final int CMPP_QUERY_LENGTH_V30 = -1;
    public static final int CMPP_QUERY_RESP = -2147483642;
    public static final int CMPP_QUERY_RESP_LENGTH_V30 = -1;
    public static final int CMPP_CANCEL = 7;
    public static final int CMPP_CANCEL_LENGTH_V30 = -1;
    public static final int CMPP_CANCEL_RESP = -2147483641;
    public static final int CMPP_CANCEL_RESP_LENGTH_V30 = -1;
    public static final int CMPP_ACTIVE_TEST = 8;
    public static final int CMPP_ACTIVE_TEST_LENGTH = 12;
    public static final int CMPP_ACTIVE_TEST_RESP = -2147483640;
    public static final int CMPP_ACTIVE_TEST_RESP_LENGTH = 13;
    public static final int USMP_SUBMITPUSH = 0x10000001;
    public static final int USMP_SUBMITPUSH_LENGTH_MIN = 161;
    public static final int USMP_SUBMITPUSH_LENGTH_MAX = 3761;
    public static final int USMP_SUBMITPUSH_RESP = -1879048191;
    public static final int USMP_SUBMITPUSH_RESP_LENGTH = 24;
    public static final int USMP_PUSHNOTIFY = 0x10000002;
    public static final int USMP_PUSHNOTIRY_LENGTH = 68;
    public static final int USMP_PUSHNOTIRY_RESP = -1879048190;
    public static final int USMP_PUSHNOTIRY_RESP_LENGTH = 24;
    public static final int HEADER_LENGTH = 12;
    protected Version version = Version.UNKNOW_VERSION;
    protected int commandId;
    protected int sequenceId;
    protected int totalLength;
    public static CmppPacket UNKNOW_PACKET = new CmppPacket(){
        private static final long serialVersionUID = 1L;

        @Override
        public byte[] pack() throws PacketException {
            return null;
        }

        @Override
        public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
            super.unpack(buffer);
            return this;
        }
    };

    public CmppPacket() {
    }

    public CmppPacket(Version version) {
        this.version = version;
    }

    private void packHeader(int totalLength, int commandId, int sequenceId) throws PacketException {
        try {
            this.allocate(totalLength);
            this.putInt(totalLength);
            this.putInt(commandId);
            this.putInt(sequenceId);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppPacket header: TotalLength=" + totalLength + ", CommandId=" + Integer.toHexString(commandId) + ", SequenceId=" + sequenceId, e);
        }
    }

    private void unpackHeader() throws PacketException {
        try {
            this.totalLength = this.getInt();
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppPacket header: ", e);
        }
        if (this.totalLength < 12) {
            throw new PacketException("CmppPacket header invalid: TotalLength=" + this.totalLength + ", CommandId=0x" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId);
        }
        this.commandId = this.getInt();
        this.sequenceId = this.getInt();
        if (!this.isValidHeader()) {
            throw new PacketException("CmppPacket header invalid: TotalLength=" + this.totalLength + ", CommandId=0x" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId);
        }
    }

    protected boolean isValidHeader() {
        boolean r = false;
        switch (this.commandId) {
            case 1: {
                r = this.totalLength == 39;
                break;
            }
            case -2147483647: {
                r = this.totalLength == (this.version.isVersion3() ? 33 : 30);
                break;
            }
            case 2: {
                r = this.totalLength == 12;
                break;
            }
            case -2147483646: {
                r = this.totalLength == 12;
                break;
            }
            case 4: {
                r = this.totalLength > (this.version.isVersion3() ? 163 : 136);
                break;
            }
            case -2147483644: {
                r = this.totalLength == (this.version.isVersion3() ? 24 : 21);
                break;
            }
            case 5: {
                r = this.totalLength > (this.version.isVersion3() ? 109 : 85);
                break;
            }
            case -2147483643: {
                r = this.totalLength == (this.version.isVersion3() ? 24 : 21);
                break;
            }
            case 6: {
                r = this.totalLength == -1;
                break;
            }
            case -2147483642: {
                r = this.totalLength == -1;
                break;
            }
            case 7: {
                r = this.totalLength == -1;
                break;
            }
            case -2147483641: {
                r = this.totalLength == -1;
                break;
            }
            case 8: {
                r = this.totalLength == 12;
                break;
            }
            case -2147483640: {
                r = this.totalLength == 13;
                break;
            }
            case 0x10000001: {
                r = this.totalLength >= 161 && this.totalLength <= 3761;
                break;
            }
            case -1879048190: {
                r = this.totalLength == 24;
            }
        }
        return r;
    }

    public byte[] pack() throws PacketException {
        this.packHeader(this.totalLength, this.commandId, this.sequenceId);
        return this.getBytes();
    }

    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        this.setByteBuffer(buffer);
        this.unpackHeader();
        return this;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

