/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import java.nio.ByteBuffer;

public class CmppDeliverRespPacket
extends CmppPacket {
    private static final long serialVersionUID = 1L;
    public static int RESULT_OK = 0;
    public static int RESULT_STRUCTURE_ERR = 1;
    public static int RESULT_COMMAND_ID_ERR = 2;
    public static int RESULT_SEQ_ID_REPEAT = 3;
    public static int RESULT_LENGTH_ERR = 4;
    public static int RESULT_FEE_CODE_ERR = 5;
    public static int RESULT_TOO_LONG = 6;
    public static int RESULT_SERVICE_ID_ERR = 7;
    public static int RESULT_TRAFFIC_ERR = 8;
    public static int RESULT_OTHER_ERR = 9;
    private long msgId;
    private int result;

    public CmppDeliverRespPacket() {
        this.totalLength = this.version.isVersion3() ? 24 : 21;
        this.commandId = -2147483643;
    }

    public CmppDeliverRespPacket(Version version) {
        super(version);
        this.totalLength = version.isVersion3() ? 24 : 21;
        this.commandId = -2147483643;
    }

    @Override
    public byte[] pack() throws PacketException {
        super.pack();
        try {
            this.putLong(this.msgId);
            if (this.version.isVersion3()) {
                this.putInt(this.result);
            } else if (this.version.isVersion2()) {
                this.put((byte)this.result);
            }
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppDeliverRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        try {
            this.msgId = this.getLong();
            this.result = this.version.isVersion3() ? this.getInt() : (int)this.get();
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on unpacking CmppDeliverRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPP_DELIVER_RESP:");
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(", Msg_Id=").append(this.msgId);
        sb.append(", Result=").append(this.result);
        return sb.toString();
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }
}

