/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.commonUtil.bytes.BytesUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CmppDeliverPacket
extends CmppPacket {
    public long autoDeliverSubmitTime;
    private static final long serialVersionUID = 1L;
    public static String STAT_DELIVERED = "DELIVRD";
    public static String STAT_EXPIRED = "EXPIRED";
    public static String STAT_DELETED = "DELETED";
    public static String STAT_UNDELIVERABLE = "UNDELIV";
    public static String STAT_ACCEPTED = "ACCEPTD";
    public static String STAT_UNKNOWN = "UNKNOWN";
    public static String STAT_REJECTED = "REJECTED";
    public static String STAT_MA = "MA:xxxx";
    public static String STAT_MB = "MB:xxxx";
    public static String STAT_CA = "CA:xxxx";
    public static String STAT_CB = "CB:xxxx";
    public static byte REGISTERED_DELIVERY_NO = 0;
    public static byte REGISTERED_DELIVERY_YES = 1;
    public static final byte MSG_TYPE_SMS_MO = 0;
    public static final byte MSG_TYPE_SMS_STAT_REPORT = 1;
    public static final byte MSG_TYPE_PUSH_STAT_REPORT = 2;
    private long msgId;
    private String destId;
    private String serviceId;
    private byte tpPid;
    private byte tpUdhi;
    private byte msgFmt;
    private String srcTerminalId;
    private byte srcTerminalType;
    private byte registeredDelivery;
    private int msgLength;
    private byte[] msgContent;
    private String linkId;
    private long ismgMsgId;
    private String stat;
    private String submitTime;
    private String doneTime;
    private String destTerminalId;
    private int smscSequence;
    private String longFlag = "";
    private byte[] longFlagByteArray = null;
    private int longFlagSize = 0;

    public CmppDeliverPacket() {
        this.commandId = 5;
    }

    public CmppDeliverPacket(Version version) {
        super(version);
        this.commandId = 5;
    }

    @Override
    public byte[] pack() throws PacketException {
        if (!this.isRegisteredDelivery() && this.msgContent == null) {
            this.msgContent = new byte[]{0};
        }
        int mainLength = this.version.isVersion3() ? 97 : 73;
        int reportLength = 60;
        int n = this.msgLength = this.isRegisteredDelivery() ? reportLength : this.msgContent.length;
        if (this.isLongSMS()) {
            this.msgLength += this.longFlagSize;
        }
        this.totalLength = 12 + mainLength + this.msgLength;
        super.pack();
        try {
            this.putLong(this.msgId);
            this.putStringRightPad(this.destId, 21);
            this.putStringRightPad(this.serviceId, 10);
            this.put(this.tpPid);
            this.put(this.tpUdhi);
            this.put(this.msgFmt);
            this.putStringRightPad(this.srcTerminalId, this.version.isVersion3() ? 32 : 21);
            if (this.version.isVersion3()) {
                this.put(this.srcTerminalType);
            }
            this.put(this.registeredDelivery);
            this.put((byte)this.msgLength);
            if (this.isRegisteredDelivery()) {
                this.putLong(this.ismgMsgId);
                this.putStringRightPad(this.stat, 7);
                this.putStringRightPad(this.submitTime, 10);
                this.putStringRightPad(this.doneTime, 10);
                this.putStringRightPad(this.destTerminalId, 21);
                this.putInt(this.smscSequence);
            } else {
                if (this.isLongSMS()) {
                    this.put(this.longFlagByteArray);
                }
                this.put(this.msgContent);
            }
            if (null != this.linkId && this.linkId.getBytes().length > 20) {
                this.linkId = null;
            }
            this.putStringRightPad(this.linkId, this.version.isVersion3() ? 20 : 8);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppDeliverPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId + ", linkId=" + this.linkId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        try {
            this.msgId = this.getLong();
            this.destId = this.getString(21);
            this.serviceId = this.getString(10);
            this.tpPid = this.get();
            this.tpUdhi = this.get();
            this.msgFmt = this.get();
            this.srcTerminalId = this.getString(this.version.isVersion3() ? 32 : 21);
            if (this.version.isVersion3()) {
                this.srcTerminalType = this.get();
            }
            this.registeredDelivery = this.get();
            this.msgLength = this.get();
            if (this.isRegisteredDelivery()) {
                this.ismgMsgId = this.getLong();
                this.stat = this.getString(7);
                this.submitTime = this.getString(10);
                this.doneTime = this.getString(10);
                this.destTerminalId = this.getString(21);
                this.smscSequence = this.getInt();
            } else {
                this.msgContent = new byte[this.msgLength];
                this.get(this.msgContent);
            }
            this.linkId = this.getString(this.version.isVersion3() ? 20 : 8);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on unpacking CmppDeliverPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public String getDestId() {
        return this.destId;
    }

    public void setDestId(String destId) {
        this.destId = destId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public byte getTpPid() {
        return this.tpPid;
    }

    public void setTpPid(byte tpPid) {
        this.tpPid = tpPid;
    }

    public byte getTpUdhi() {
        return this.tpUdhi;
    }

    public void setTpUdhi(byte tpUdhi) {
        this.tpUdhi = tpUdhi;
    }

    public byte getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(byte msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getSrcTerminalId() {
        return this.srcTerminalId;
    }

    public void setSrcTerminalId(String srcTerminalId) {
        this.srcTerminalId = srcTerminalId;
    }

    public byte getSrcTerminalType() {
        return this.srcTerminalType;
    }

    public void setSrcTerminalType(byte srcTerminalType) {
        this.srcTerminalType = srcTerminalType;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(boolean isRegisteredDelivery) {
        this.registeredDelivery = isRegisteredDelivery ? REGISTERED_DELIVERY_YES : REGISTERED_DELIVERY_NO;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int msgLenght) {
        this.msgLength = msgLenght;
    }

    public byte[] getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(byte[] msgContent) {
        this.msgContent = msgContent;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getReserved() {
        return this.linkId;
    }

    public void setLinkId(String linkId) throws UnsupportedEncodingException {
        this.setLinkidORReserved(linkId);
        if (this.isLongSMS() && ArrayUtils.isNotEmpty((byte[])this.msgContent)) {
            String msg = new String(this.msgContent, "GBK");
            this.msgContent = msg.getBytes("UTF-16BE");
        }
    }

    public void setReserved(String reserved) {
        this.setLinkidORReserved(reserved);
    }

    private void setLinkidORReserved(String str) {
        if (StringUtils.contains((CharSequence)str, (CharSequence)"#")) {
            this.longFlag = StringUtils.substringBefore((String)str, (String)"#");
            this.linkId = StringUtils.substringAfter((String)str, (String)"#");
            if (StringUtils.isNotBlank((CharSequence)this.longFlag)) {
                this.longFlagByteArray = BytesUtil.hex2bytes((String)this.longFlag);
                this.longFlagSize = ArrayUtils.getLength((Object)this.longFlagByteArray);
            }
            if (this.isLongSMS()) {
                this.msgFmt = (byte)8;
                this.tpUdhi = 1;
            }
        } else {
            this.linkId = str;
        }
    }

    public long getIsmgMsgId() {
        return this.ismgMsgId;
    }

    public void setIsmgMsgId(long msgId) {
        this.ismgMsgId = msgId;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(String submitTime) {
        this.submitTime = submitTime;
    }

    public String getDoneTime() {
        return this.doneTime;
    }

    public void setDoneTime(String doneTime) {
        this.doneTime = doneTime;
    }

    public String getDestTerminalId() {
        return this.destTerminalId;
    }

    public void setDestTerminalId(String destTerminalId) {
        this.destTerminalId = destTerminalId;
    }

    public int getSmscSequence() {
        return this.smscSequence;
    }

    public void setSmscSequence(int smscSequence) {
        this.smscSequence = smscSequence;
    }

    public boolean isRegisteredDelivery() {
        return this.registeredDelivery == REGISTERED_DELIVERY_YES;
    }

    public void setSubmitTime(Date date) {
        if (date == null) {
            return;
        }
        this.submitTime = DateFormatUtils.format((Date)date, (String)"yyMMddHHmm");
    }

    public void setDoneTime(Date date) {
        if (date == null) {
            return;
        }
        this.doneTime = DateFormatUtils.format((Date)date, (String)"yyMMddHHmm");
    }

    public boolean isSMSMO() {
        return 0 == this.registeredDelivery;
    }

    public boolean isSMSReport() {
        return 1 == this.registeredDelivery;
    }

    public boolean isPushReport() {
        return 2 == this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getMsgContentDecoded() {
        String ret = null;
        if (this.isRegisteredDelivery()) {
            return ret;
        }
        try {
            switch (this.msgFmt) {
                case 0: {
                    ret = new String(this.msgContent, "US-ASCII");
                    break;
                }
                case 4: {
                    ret = BytesUtil.bytes2hex((byte[])this.msgContent);
                    break;
                }
                case 8: {
                    ret = new String(this.msgContent, "UTF-16BE");
                    break;
                }
                case 15: {
                    ret = new String(this.msgContent, "GBK");
                    break;
                }
                default: {
                    ret = new String(this.msgContent);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            ret = new String(this.msgContent);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isRegisteredDelivery()) {
            sb.append("[Report]CMPP_DELIVER:");
        } else {
            sb.append("CMPP_DELIVER:");
        }
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(", Msg_Id=").append(this.msgId);
        if (this.isRegisteredDelivery()) {
            sb.append(", IMSG_Msg_Id=").append(this.ismgMsgId);
            sb.append(", Stat=").append(this.stat);
            sb.append(", Submit_time=").append(this.submitTime);
            sb.append(", Done_time=").append(this.doneTime);
            sb.append(", Dest_terminal_Id=").append(this.destTerminalId);
            sb.append(", SMSC_sequence=").append(this.smscSequence);
        } else {
            sb.append(", Dest_Id=").append(this.destId);
            sb.append(", Service_Id=").append(this.serviceId);
            sb.append(", TP_pid=").append(this.tpPid);
            sb.append(", TP_udhi=").append(this.tpUdhi);
            sb.append(", Msg_Fmt=").append(this.msgFmt);
            sb.append(", Src_terminal_Id=").append(this.srcTerminalId);
            sb.append(", Src_terminal_type=").append(this.srcTerminalType);
            sb.append(", Registered_Delivery=").append(this.registeredDelivery);
            sb.append(", Msg_Length=").append(this.msgLength);
            sb.append(", Msg_Content=").append(this.getMsgContentDecoded());
            sb.append(", LinkID=").append(this.linkId);
            if (this.isLongSMS()) {
                sb.append(", LongFlag=").append(this.longFlag);
            }
        }
        sb.append(", resend =").append(this.bizParams);
        return sb.toString();
    }

    private boolean isLongSMS() {
        return this.longFlagSize == 6 || this.longFlagSize == 7;
    }
}

