/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.commonUtil.bytes.BytesUtil;
import java.nio.ByteBuffer;

public class CmppConnectRespPacket
extends CmppPacket {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_SRC_ADDRESS_ERR = 2;
    public static final int STATUS_AUTH_ERR = 3;
    public static final int STATUS_CONNECTIONS_LIMIT = 1001;
    public static final int STATUS_IP_LIMIT = 1002;
    private int status;
    private byte[] authenticatorISMG;

    public CmppConnectRespPacket(Version version) {
        super(version);
        this.commandId = -2147483647;
        if (version.isVersion3()) {
            this.totalLength = 33;
        } else if (version.isVersion2()) {
            this.totalLength = 30;
        }
    }

    @Override
    public byte[] pack() throws PacketException {
        super.pack();
        try {
            if (this.version.isVersion3()) {
                this.putInt(this.status);
            } else if (this.version.isVersion2()) {
                this.put((byte)this.status);
            }
            this.put(this.authenticatorISMG, 0, 16);
            this.put(this.version.getVersion());
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppConnectRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        try {
            this.status = this.getInt();
            this.authenticatorISMG = new byte[16];
            this.get(this.authenticatorISMG);
            byte ver = this.get();
            this.version = Version.toVersion(ver);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on unpacking CmppConnectRespPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getAuthenticatorISMG() {
        return this.authenticatorISMG;
    }

    public void setAuthenticatorISMG(byte[] authenticatorISMG) {
        this.authenticatorISMG = authenticatorISMG;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    public String getAuthenticatorISMGHexString() {
        return BytesUtil.bytes2hex((byte[])this.authenticatorISMG);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPP_CONNECT_RESP:");
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(",Status=").append(this.status);
        sb.append(",AuthenticatorISMG=").append(this.getAuthenticatorISMGHexString());
        sb.append(",Version=").append(this.version.getDescription());
        return sb.toString();
    }
}

