/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.commonUtil.bytes.BytesUtil;
import java.nio.ByteBuffer;

public class CmppConnectPacket
extends CmppPacket {
    private static final long serialVersionUID = 1L;
    private String sourceAddr;
    private byte[] authenticatorSource;
    private int timestamp;
    private int ver;

    public CmppConnectPacket() {
        this.commandId = 1;
        this.totalLength = 39;
    }

    public CmppConnectPacket(Version version) {
        super(version);
        this.commandId = 1;
        this.totalLength = 39;
    }

    @Override
    public byte[] pack() throws PacketException {
        super.pack();
        try {
            this.putStringRightPad(this.sourceAddr, 6);
            this.put(this.authenticatorSource, 0, 16);
            this.putInt(this.version.getVersion());
            this.putInt(this.timestamp);
        }
        catch (Exception e) {
            throw new PacketException("Unexpected Exception on packing CmppConnectPacket: TotalLength=" + this.totalLength + ", CommandId=" + Integer.toHexString(this.commandId) + ", SequenceId=" + this.sequenceId, e);
        }
        return this.getBytes();
    }

    @Override
    public CmppPacket unpack(ByteBuffer buffer) throws PacketException {
        super.unpack(buffer);
        this.sourceAddr = this.getString(6);
        this.authenticatorSource = new byte[16];
        this.get(this.authenticatorSource);
        this.ver = this.get();
        this.version = Version.toVersion(this.ver);
        this.timestamp = this.getInt();
        return this;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public byte[] getAuthenticatorSource() {
        return this.authenticatorSource;
    }

    public void setAuthenticatorSource(byte[] authenticatorSource) {
        this.authenticatorSource = authenticatorSource;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String getAuthenticatorSourceHexString() {
        return BytesUtil.bytes2hex((byte[])this.authenticatorSource);
    }

    public Version getVersion() {
        return this.version;
    }

    public int getVer() {
        return this.ver;
    }

    public void setVer(int ver) {
        this.ver = ver;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CMPP_CONNECT:");
        sb.append("Sequence_Id=").append(this.sequenceId);
        sb.append(",Source_Addr=").append(this.sourceAddr);
        sb.append(",AuthenticatorSource=").append(this.getAuthenticatorSourceHexString());
        sb.append(",Version=").append(this.version.getDescription());
        sb.append(",Timestamp=").append(this.timestamp);
        return sb.toString();
    }
}

