/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter.coder;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppActiveTestRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.PacketException;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import java.nio.ByteBuffer;
import javax.annotation.Resource;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.springframework.stereotype.Service;

@Service
public class CmppProtocolDecoder
extends CumulativeProtocolDecoder {
    @Resource
    private SysRunTimeService sysRunTimeService;

    private CmppPacket decode(IoSession session, byte[] bytes) throws PacketException {
        CmppPacket pk = null;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int commandId = buffer.getInt(4);
        Version version = null;
        switch (commandId) {
            case 1: {
                pk = new CmppConnectPacket();
                break;
            }
            case 8: {
                pk = new CmppActiveTestPacket();
                break;
            }
            case -2147483640: {
                pk = new CmppActiveTestRespPacket();
                pk.bizParams = new Object();
                break;
            }
            case 4: {
                version = this.sysRunTimeService.getUserRunTime(session).getConnection(session).getVersion();
                pk = new CmppSubmitPacket(version);
                break;
            }
            case -2147483643: {
                version = this.sysRunTimeService.getUserRunTime(session).getConnection(session).getVersion();
                pk = new CmppDeliverRespPacket(version);
                break;
            }
            default: {
                pk = CmppPacket.UNKNOW_PACKET;
            }
        }
        pk.unpack(buffer);
        return pk;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws PacketException {
        if (in.remaining() < 12 || in.getInt(in.position()) < 12 || in.remaining() < in.getInt(in.position())) {
            return false;
        }
        int totalLength = in.getInt(in.position());
        byte[] bytes = new byte[totalLength];
        in.get(bytes);
        CmppPacket pk = this.decode(session, bytes);
        if (pk == null) {
            return false;
        }
        out.write((Object)pk);
        return true;
    }
}

