/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppTerminateRespPacket;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.util.LogService;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.springframework.stereotype.Service;

@Service
public class LoginFilter
extends IoFilterAdapter {
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;

    /*
     * Enabled aggressive block sorting
     */
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof CmppConnectRespPacket) {
            CmppConnectRespPacket cmppConnectRespPacket = (CmppConnectRespPacket)writeRequest.getMessage();
            CmppConnectPacket cmppConnectPacket = (CmppConnectPacket)cmppConnectRespPacket.bizParams;
            if (cmppConnectRespPacket.getStatus() != 0) {
                session.close(true);
                this.logService.connect(session, cmppConnectPacket);
                this.logService.connectResp(session, cmppConnectRespPacket);
                return;
            }
            this.sysRunTimeService.addSession(cmppConnectPacket.getSourceAddr(), session, cmppConnectRespPacket.getVersion());
            this.logService.connect(session, cmppConnectPacket);
            this.logService.connectResp(session, cmppConnectRespPacket);
        } else if (writeRequest.getMessage() instanceof CmppTerminateRespPacket) {
            session.close(true);
            return;
        }
        nextFilter.messageSent(session, writeRequest);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.logService.close(session);
        this.sysRunTimeService.removeSession(session);
        nextFilter.sessionClosed(session);
    }
}

