/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.runTime.Connection;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.springframework.stereotype.Service;

@Service
public class CountFilter
extends IoFilterAdapter {
    @Resource
    private SysRunTimeService sysRunTimeService;

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        Connection connection;
        UserRunTime userRunTime;
        if (message instanceof CmppSubmitPacket) {
            this.sysRunTimeService.getMoMtCounter().getMtCounter().increment();
            userRunTime = this.sysRunTimeService.getUserRunTime(session);
            userRunTime.getMoMtCounter().getMtCounter().increment();
            connection = userRunTime.getConnection(session);
            connection.getMoMtCounter().getMtCounter().increment();
        }
        if (message instanceof CmppDeliverRespPacket) {
            this.sysRunTimeService.getMoMtCounter().getMoReportRespCounter().increment();
            userRunTime = this.sysRunTimeService.getUserRunTime(session);
            userRunTime.getMoMtCounter().getMoReportRespCounter().increment();
            connection = userRunTime.getConnection(session);
            connection.getMoMtCounter().getMoReportRespCounter().increment();
        }
        nextFilter.messageReceived(session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof CmppSubmitRespPacket) {
            int result = ((CmppSubmitRespPacket)writeRequest.getMessage()).getResult();
            if (result == CmppSubmitRespPacket.RESULT_OK) {
                this.sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().increment();
                UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(session);
                userRunTime.getMoMtCounter().getMtRespSucessCounter().increment();
                Connection connection = userRunTime.getConnection(session);
                connection.getMoMtCounter().getMtRespSucessCounter().increment();
            } else {
                this.sysRunTimeService.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
                UserRunTime userRunTime = this.sysRunTimeService.getUserRunTime(session);
                userRunTime.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
                Connection connection = userRunTime.getConnection(session);
                connection.getMoMtCounter().getMtRespFailCounter().increment(CmppSubmitRespPacket.FailDetailMap.get(result));
            }
        }
        nextFilter.messageSent(session, writeRequest);
    }
}

