/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter;

import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppConnectPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.util.LogService;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.springframework.stereotype.Service;

@Service
public class CmppFilter
extends IoFilterAdapter {
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof CmppConnectPacket) {
            if (this.sysRunTimeService.isConnected(session)) {
                this.logService.reSendCmppConnectPacket(session);
                this.sysRunTimeService.getForbiddenCmppCount().increment();
            } else if (Version.UNKNOW_VERSION.equals(((CmppConnectPacket)message).getVersion())) {
                this.logService.versionErr(session);
                this.sysRunTimeService.getForbiddenCmppCount().increment();
                session.close(true);
            } else {
                nextFilter.messageReceived(session, message);
            }
        } else if (!this.sysRunTimeService.isConnected(session)) {
            this.logService.sendCmppPacketWithUnConnected(session);
            this.sysRunTimeService.getForbiddenCmppCount().increment();
            session.close(true);
        } else {
            nextFilter.messageReceived(session, message);
        }
    }
}

