/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver.filter;

import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.util.LogService;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.firewall.Subnet;
import org.springframework.stereotype.Service;

@Service
public class AdressFilter
extends IoFilterAdapter {
    @Resource
    private LogService logService;
    @Resource
    private SysRunTimeService sysRunTimeService;
    private List<Subnet> blackList = new CopyOnWriteArrayList<Subnet>();

    public void add(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Adress to block can not be null");
        }
        this.blackList.add(new Subnet(address, 32));
    }

    public void remove(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Adress to unblock can not be null");
        }
        this.blackList.remove(new Subnet(address, 32));
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        if (!this.isBlack(session)) {
            nextFilter.sessionCreated(session);
        } else {
            this.sysRunTimeService.getForBiddenIpCount().increment();
            this.logService.refuseIp(session);
            session.close(true);
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlack(session)) {
            nextFilter.sessionOpened(session);
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlack(session)) {
            nextFilter.sessionClosed(session);
        }
    }

    private boolean isBlack(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetAddress address = ((InetSocketAddress)remoteAddress).getAddress();
            for (Subnet subnet : this.blackList) {
                if (!subnet.inSubnet(address)) continue;
                return true;
            }
        }
        return false;
    }
}

