/*
 * Decompiled with CFR 0.152.
 */
package com.aspire.nm.component.cmppserver;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.AdressFilter;
import com.aspire.nm.component.cmppserver.plugins.ProcessSubmit;
import com.aspire.nm.component.cmppserver.runTime.RunTimeInfoBuilder;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.server.CmppAcceptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class CmppServer
implements InitializingBean {
    @Resource
    private RunTimeInfoBuilder runTimeInfoBuilder;
    @Resource
    private SysRunTimeService sysRunTimeService;
    @Resource
    private CmppAcceptor cmppAcceptor;
    @Resource
    private AdressFilter adressFilter;
    @Value(value="${processSubmitImplClassName}")
    private String processSubmitImplClassName;
    private ProcessSubmit processSubmit;

    public ProcessSubmit getProcessSubmit() {
        return this.processSubmit;
    }

    public void setProcessSubmit(ProcessSubmit processSubmit) {
        this.processSubmit = processSubmit;
    }

    public void afterPropertiesSet() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        if (!StringUtils.isEmpty((CharSequence)this.processSubmitImplClassName)) {
            this.processSubmit = (ProcessSubmit)Class.forName(this.processSubmitImplClassName).newInstance();
        }
    }

    public void start() throws IOException {
        try {
            Class.forName("com.aspire.nm.component.cmppserver.util.InvokeRateUtil");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.cmppAcceptor.start();
    }

    public void stop() throws IOException {
        this.cmppAcceptor.stop();
    }

    public void addBlackIps(List<String> blackIps) throws UnknownHostException {
        for (String blackIp : blackIps) {
            this.adressFilter.add(InetAddress.getByName(blackIp));
        }
    }

    public String getRunTimeInfo() {
        try {
            return this.runTimeInfoBuilder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CmppServer addClientConfig(ClientConfig clientConfig) throws UnknownHostException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (clientConfig.getUsername().length() > 6) {
            throw new RuntimeException("username.length > 6 , username = " + clientConfig.getUsername());
        }
        if (this.sysRunTimeService.getClientConfig(clientConfig.getUsername()) != null) {
            return this;
        }
        this.sysRunTimeService.addClientConfig(clientConfig.getUsername(), clientConfig);
        return this;
    }

    public void removeClientConfig(String user) {
        this.sysRunTimeService.removeClientConfig(user);
    }

    public UserRunTime getUserRunTime(String user) {
        return this.sysRunTimeService.getUserRunTime(user);
    }
}

