package com.aspire.nm.component.cmppserver.validate;


import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppSubmitRespPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.plugins.KeyWordVerify;
import com.aspire.nm.component.cmppserver.plugins.TerminalIdVerify;
import com.aspire.nm.component.cmppserver.runTime.SysRunTimeService;
import com.aspire.nm.component.cmppserver.runTime.UserRunTime;
import com.aspire.nm.component.cmppserver.util.LogService;


@Service
public class CmppSubmitPacketCheck implements InitializingBean{
	
	
	
	
	@Value("${terminalIdVerifyImplClassName}")
	private String terminalIdVerifyImplClassName;
	@Value("${keyWordVerifyImplClassName}")
    private String keyWordVerifyImplClassName;
    
	
	private TerminalIdVerify terminalIdVerify;
	private KeyWordVerify keyWordVerify;
	
	@Override
    public void afterPropertiesSet() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
	    if(!StringUtils.isEmpty(terminalIdVerifyImplClassName)){
	        terminalIdVerify = (TerminalIdVerify) Class.forName(terminalIdVerifyImplClassName).newInstance();
	    }
	    if(!StringUtils.isEmpty(keyWordVerifyImplClassName)){
	        keyWordVerify = (KeyWordVerify) Class.forName(keyWordVerifyImplClassName).newInstance();
        }
    }
	
	
	@Resource
	private LogService logService;
	
	@Resource
	private SysRunTimeService sysRunTimeService;
	
	public int check(CmppSubmitPacket pk, IoSession session,Version version) {
		
		if (version.isSingleMOVersion()) {
			return CmppSubmitRespPacket.RESULT_REJECT;
		}
    	if (pk.getSrcId() == null || pk.getSrcId().trim().equals("") || pk.getSrcId().trim().length() > 20) {
			return CmppSubmitRespPacket.RESULT_SRC_ID_ERR;
		}
    	if (pk.getServiceId() == null || pk.getServiceId().trim().equals("")) {
			return CmppSubmitRespPacket.RESULT_SERVICE_ID_ERR;
		}
		if (pk.getFeeType().length() != 2) {
			return CmppSubmitRespPacket.RESULT_FEETYPE_ERR;
		}
		if (pk.getFeeCode() != null && !pk.getFeeCode().trim().equals("") && !pk.getFeeCode().matches("\\d+")) {
			return CmppSubmitRespPacket.RESULT_FEE_CODE_ERR;
		}
		if (pk.getMsgLength() <= 0) {
			return CmppSubmitRespPacket.RESULT_MSG_LENGTH_ERR;
		}
		if (pk.getMsgFmt()!=CmppSubmitPacket.MSG_FMT_FLASH && ((pk.getMsgFmt() == CmppSubmitPacket.MSG_FMT_ASCII && pk
				.getMsgLength() >= 160)
				|| (pk.getMsgFmt() != CmppSubmitPacket.MSG_FMT_ASCII && pk
						.getMsgLength() > 140))) {
			return CmppSubmitRespPacket.RESULT_MSG_TOO_LONG;
		}
		
		
		
		UserRunTime userRunTime = sysRunTimeService.getUserRunTime(session);
		ClientConfig clientConfig = sysRunTimeService.getClientConfig(userRunTime.getUser());
		
		if(clientConfig.getServiceId() != null && !pk.getServiceId().equals(clientConfig.getServiceId())){
		    return CmppSubmitRespPacket.RESULT_SERVICE_ID_ERR;
		}
		if(clientConfig.getSrcid() != null && !pk.getSrcId().startsWith(clientConfig.getSrcid())){
			return CmppSubmitRespPacket.RESULT_SRC_ID_ERR;
		}
		
		if(terminalIdVerify != null){
		    for(String mobile:pk.getDestTerminalId()){
		        if(!terminalIdVerify.verify(mobile)){
		            return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_ERR;
		        }
	        }
		}
		if (clientConfig.getDayMtLimit() != 0 && userRunTime.getMoMtCounter().getMtCounter().getDailyCount().getCount().get() > clientConfig.getDayMtLimit()) {
			return CmppSubmitRespPacket.RESULT_DAYLIMIT_ERR;
		}
		int mtLimitInsec = clientConfig.getMtLimitInSec();
		if(mtLimitInsec != 0 && userRunTime.getConnection(session).getMtSpeedController().isTimeLimitInSecond(mtLimitInsec, false)){
			return CmppSubmitRespPacket.RESULT_SECONDLIMIT_ERR;
		}
		
		
		if(clientConfig.getBlackDestTerminalId() != null){
			for (int i = 0; i < pk.getDestTerminalId().length; i++) {
				if (clientConfig.getBlackDestTerminalId().contains(pk.getDestTerminalId()[i])){
					return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_BLACK_ERR;
				}
			}
		}
		if(clientConfig.getWhileDestTerminalId() != null){
			for (int i = 0; i < pk.getDestTerminalId().length; i++) {
				if (clientConfig.getWhileDestTerminalId().contains(pk.getDestTerminalId()[i])){
					continue;
				}
				return CmppSubmitRespPacket.RESULT_DEST_TERMINAL_ID_WHILE_ERR;
			}
		}
		
		//敏感词过滤
		if(keyWordVerify != null){
		    if(!keyWordVerify.verify(pk.getMsgContentDecoded())){
                return CmppSubmitRespPacket.RESULT_FILTER_KEYWORD;
            }
		}
		return CmppSubmitRespPacket.RESULT_OK;
	}

    
}
