/*
 * @ (#) MessageIdGenerator.java Jun 10, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.util;


import java.util.Calendar;
import java.util.Random;

import com.aspire.nm.component.commonUtil.seq.SequenceGenerator;

/**
 * CMPP Msg_Id生成器
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class MessageIdGenerator {
	
	private static int seed;
	{
		seed =  (Math.abs(new Random().nextInt()))%(1000 - 1 + 1)+1;
	}
	private SequenceGenerator seq = SequenceGenerator.getSequenceGenerator(0, 0xffff);
	
	private Calendar calender = Calendar.getInstance();
	private static MessageIdGenerator instance=new MessageIdGenerator();
	public  synchronized static  MessageIdGenerator getMessageIdGenerator(){
		return instance;
	}
	
	/**
	 * 采用64位（8字节）的整数：
	 * （1）时间（格式为MMDDHHMMSS，即月日时分秒）：bit64~bit39，其中
	 * bit64~bit61：月份的二进制表示； bit60~bit56：日的二进制表示； bit55~bit51：小时的二进制表示； bit50~bit45：分的二进制表示； bit44~bit39：秒的二进制表示；
	 * （2）短信网关代码：bit38~bit17，把短信网关的代码转换为整数填写到该字段中。
	 * （3）序列号：bit16~bit1，顺序增加，步长为1，循环使用。
	 * 各部分如不能填满，左补零，右对齐。
	 * 
	 * @param gwid
	 * @return 计算后的MsgId
	 */
	public synchronized long getMsgId(short skip){
		calender.setTimeInMillis(System.currentTimeMillis());
		
		long MM = calender.get(Calendar.MONTH) + 1;
		long dd = calender.get(Calendar.DAY_OF_MONTH);
		long hh = calender.get(Calendar.HOUR_OF_DAY);
		long mm = calender.get(Calendar.MINUTE);
		long SS = calender.get(Calendar.SECOND);
		
		long id = 0x0000000000000000;
		
		id = id | (MM << 60); // 4bit
		id = id | (dd << 55); // 5bit
		id = id | (hh << 50); // 5bit
		id = id | (mm << 44); // 6bit
		id = id | (SS << 38); // 6bit
		
		id = id | (seed << 16);
		
		id = id | seq.next(skip);
		return id;
		
	}
}
