package com.aspire.nm.component.cmppserver.server;

import java.io.IOException;
import java.net.InetSocketAddress;

import javax.annotation.Resource;

import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CmppAcceptor{
	
	@Resource(name = "ioAcceptor")
	private SocketAcceptor acceptor;
	
	
	@Value("${cmppserver.serverPort}")
	private int serverPort;
	
	
	
	

	public void start() throws IOException{
		SocketSessionConfig sessionConfig = acceptor.getSessionConfig();
		sessionConfig.setReceiveBufferSize(4096*1024);
		sessionConfig.setSendBufferSize(4096*1024);
		sessionConfig.setKeepAlive(true);
		sessionConfig.setSoLinger(0); //解决过多TIME_WAIT的问题
		sessionConfig.setTcpNoDelay(true);
		sessionConfig.setUseReadOperation(false);
		sessionConfig.setReuseAddress(true);
		
		InetSocketAddress socketAddress = new InetSocketAddress(serverPort);
		acceptor.bind(socketAddress);
	}
	
	public void stop() throws IOException {
		acceptor.unbind();
	}

	
}
