package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.concurrent.atomic.AtomicLong;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope("prototype")
@Component
public class SpeedCounter extends Thread implements InitializingBean{
	
	@Override
	public void afterPropertiesSet() throws Exception {
		start();
	}
	private AtomicLong count = new AtomicLong();
	private long countPerSec;
	
	
	public void increment(){
		count.incrementAndGet();
	}
	
	
	public AtomicLong getCount() {
		return count;
	}
	public long getCountPerSec() {
		return countPerSec;
	}
	
	
	
	private long preSecCount;
	public void run(){
		while(true){
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
			countPerSec = count.get() - preSecCount;
			preSecCount = count.get();
		}
	}
}
