package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.concurrent.atomic.AtomicLong;

import javax.annotation.Resource;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope("prototype")
@Component
public class ForbiddenCounter {

	private long lastCountTimes;
	
	@Resource
	private DailyCount dailyCount;
	private AtomicLong count = new AtomicLong();
	
	public void increment(){
		count.incrementAndGet();
		dailyCount.increment();
		lastCountTimes = System.currentTimeMillis();
	}

	public long getLastCountTimes() {
		return lastCountTimes;
	}

	public DailyCount getDailyCount() {
		return dailyCount;
	}

	public AtomicLong getCount() {
		return count;
	}
}
