package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import javax.annotation.Resource;

import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;


@Scope("prototype")
@Component
public class FailCounter extends ApplicationObjectSupport{

	private long lastCountTimes;
	
	@Resource
	private DailyCount dailyCount;
	private AtomicLong count = new AtomicLong();
	
	
	
	private ConcurrentHashMap <String,FailDetailCounter> detailMap = new ConcurrentHashMap <String,FailDetailCounter>();
	public ConcurrentHashMap<String, FailDetailCounter> getDetailMap() {
		return detailMap;
	}

	public void increment(String detail){
		count.incrementAndGet();
		dailyCount.increment();
		lastCountTimes = System.currentTimeMillis();
		
		if(detailMap.get(detail) == null){
			 detailMap.put(detail, getApplicationContext().getBean(FailDetailCounter.class));
		}
		detailMap.get(detail).increment();
	}

	public long getLastCountTimes() {
		return lastCountTimes;
	}

	public DailyCount getDailyCount() {
		return dailyCount;
	}

	public AtomicLong getCount() {
		return count;
	}
}
