package com.aspire.nm.component.cmppserver.runTime.counter;

import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;


@Scope("prototype")
@Component
public class DailyCount extends Thread implements InitializingBean{
	@Override
	public void afterPropertiesSet() throws Exception {
		start();
	}
	
	public void increment(){
		count.incrementAndGet();
	}
	
	
	public void run()
	{
		while(true){ 
			try {
				sleep(getSleepMillis());
				sleep(100);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
			yesToDayCount.set(count.get());
			count.set(0);
		}
	}
	
	private long getSleepMillis() {
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(System.currentTimeMillis());
		cal.set(Calendar.HOUR_OF_DAY, cal.get(Calendar.HOUR_OF_DAY) + 1);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		return cal.getTimeInMillis() - System.currentTimeMillis();
	}
	
	
	
	
	
	
	
	private AtomicLong yesToDayCount = new AtomicLong();
	private AtomicLong count = new AtomicLong();
	public AtomicLong getYesToDayCount() {
		return yesToDayCount;
	}
	public AtomicLong getCount() {
		return count;
	}
}
