package com.aspire.nm.component.cmppserver.runTime.counter;

import javax.annotation.Resource;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope("prototype")
@Component
public class Counter {

	private long lastCountTimes;
	
	@Resource
	private DailyCount dailyCount;
	@Resource
	private SpeedCounter speedCounter;
	
	
	public void increment(){
		dailyCount.increment();
		speedCounter.increment();
		lastCountTimes = System.currentTimeMillis();
	}


	public long getLastCountTimes() {
		return lastCountTimes;
	}
	public DailyCount getDailyCount() {
		return dailyCount;
	}
	public SpeedCounter getSpeedCounter() {
		return speedCounter;
	}
}
