package com.aspire.nm.component.cmppserver.runTime;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.mina.core.session.IoSession;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Component;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.CmppDeliverPacket;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.cmppserver.runTime.moProcess.queue.MOQueue;
import com.aspire.nm.component.cmppserver.util.InvokeRateUtil;
import com.aspire.nm.component.cmppserver.util.LogService;

@Scope("prototype")
@Component
public class UserRunTime extends ApplicationObjectSupport{

	@Resource
	private LogService logService;
	
	@Resource
    private MOQueue<CmppDeliverPacket> mOQueue;
    public MOQueue<CmppDeliverPacket> getmOQueue() {
        return mOQueue;
    }
    
    
    @Resource
    private SpeedController speedController;
    
	@Resource 
	private MoMtCounter moMtCounter;
	
	//上行超时重发
	private int resendTimes;
	public int getResendTimes() {
		return resendTimes;
	}
	public void setResendTimes(int resendTimes) {
		this.resendTimes = resendTimes;
	}
	
	private String user;
	private ClientConfig clientConfig;
	
	
	public MoMtCounter getMoMtCounter() {
		return moMtCounter;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public void setClientConfig(ClientConfig clientConfig) {
		this.clientConfig = clientConfig;
	}
	public String getUser() {
		return user;
	}
	public ClientConfig getClientConfig() {
		return clientConfig;
	}
	
	
	
	
	
	
	
	private List<Connection> connections = new ArrayList<Connection>();
	public List<Connection> getConnections() {
		return connections;
	}
	
	
	public void addSession(IoSession session,Version version){
	    
		Connection connection = getApplicationContext().getBean(Connection.class);
		connection.setSession(session);
		connection.setVersion(version);
		connection.setUserRunTime(this);
		
		connection.getMoSender().setConnection(connection);
		
		connections.add(connection);
	}
	public boolean removeSession(IoSession session){
		for(int i = 0 ;i < connections.size();i ++){
			if(connections.get(i).equals(session)){
			    connections.get(i).getMoSender().getT().interrupt();
				connections.remove(i);
				return true;
			}
		}
		return false;
		
	}
	public int getConnNum(){
		return connections.size();
	}
	public boolean haveMoConn(){
		for(Connection connection : connections){
			if(connection.isMoConn()){
				return true;
			}
		}
		return false;
	}
	public Connection getConnection(IoSession session){
		for(Connection connection : connections){
			if(connection.equals(session)){
				return connection;
			}
		}
		return null;
	}
	
	
	
	
	public boolean addMo(CmppDeliverPacket cmppDeliverPacket,boolean block){
	    if(block){
	      //上行限速
	        int moLimitInSec = clientConfig.getMoLimitInSec();
	        if(moLimitInSec != 0){
	            speedController.isTimeLimitInSecond(moLimitInSec, true);
	        }
	    }
        if(block){
            try {
                mOQueue.put(cmppDeliverPacket);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }else{
            if(!mOQueue.offer(cmppDeliverPacket)){
                return false;
            }
        }

        InvokeRateUtil.invokeRate_add_deliver.count();
        
        return true;
    }
}
