package com.aspire.nm.component.cmppserver.runTime;

import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;

import javax.annotation.Resource;

import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Service;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.counter.ForbiddenCounter;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.commonUtil.date.DateUtil;


@Service
public class SysRunTimeService extends ApplicationObjectSupport implements InitializingBean{
	
	@Override
	public void afterPropertiesSet() throws Exception {
		systemStartTime = DateUtil.getCurDateTime();
	}
	
	private String systemStartTime;
	@Resource 
	private MoMtCounter moMtCounter;
	
	@Resource
	private ForbiddenCounter forBiddenIpCount;
	@Resource
	private ForbiddenCounter forbiddenCmppCount;
	
	
	//上行超时重发
	private int resendTimes;
	public int getResendTimes() {
		return resendTimes;
	}
	public void setResendTimes(int resendTimes) {
		this.resendTimes = resendTimes;
	}
	

	public String getSystemStartTime() {
		return systemStartTime;
	}
	public MoMtCounter getMoMtCounter() {
		return moMtCounter;
	}
	public ForbiddenCounter getForBiddenIpCount() {
		return forBiddenIpCount;
	}
	public void setForBiddenIpCount(ForbiddenCounter forBiddenIpCount) {
		this.forBiddenIpCount = forBiddenIpCount;
	}
	public ForbiddenCounter getForbiddenCmppCount() {
		return forbiddenCmppCount;
	}
	public void setForbiddenCmppCount(ForbiddenCounter forbiddenCmppCount) {
		this.forbiddenCmppCount = forbiddenCmppCount;
	}
	
	
	
	
	
	
	

	private TreeMap<String,UserRunTime> userRunTimeHt = new TreeMap<String,UserRunTime>();
	private Hashtable<Long,UserRunTime> sessionIdRunTimeHt = new Hashtable<Long,UserRunTime>();
	
	
	
	
	
	
	
	
	
	public void addClientConfig(String user,ClientConfig clientConfig) throws UnknownHostException{
		synchronized(userRunTimeHt){
		    
			UserRunTime userRunTime = getApplicationContext().getBean(UserRunTime.class);
			userRunTime.setUser(user);
			userRunTime.setClientConfig(clientConfig);
			
			
			userRunTimeHt.put(user, userRunTime);
			
		}
	}
	
	public void removeClientConfig(String user){
	    synchronized(userRunTimeHt){
	        UserRunTime usrRunTime = userRunTimeHt.get(user);
	        if(usrRunTime != null){
	            Iterator<Connection> it = usrRunTime.getConnections().iterator();
	            while(it.hasNext()){
	                it.next().getSession().close(true);
	            }
	            userRunTimeHt.remove(user);
	        }
	    }
	}
	        
	public ClientConfig getClientConfig(String user){
		synchronized(userRunTimeHt){
			UserRunTime userRunTime = userRunTimeHt.get(user);
			if(userRunTime == null){
				return null;
			}else{
				return userRunTime.getClientConfig();
			}
		}
	}
	
	
	
	
	
	public void addSession(String user,IoSession session,Version version){
		UserRunTime userRunTime = userRunTimeHt.get(user);
		if(userRunTime != null){
			userRunTime.addSession(session, version);
			sessionIdRunTimeHt.put(session.getId(), userRunTime);
		}
	}
	public boolean removeSession(IoSession session){
		UserRunTime userRunTime =  sessionIdRunTimeHt.get(session.getId());
		if(userRunTime != null){
			sessionIdRunTimeHt.remove(session.getId());
			return userRunTime.removeSession(session);
		}else{
			return false;
		}
		
	}

	public TreeMap<String,UserRunTime> getUserRunTimeHt(){
		return userRunTimeHt;
	}
	public UserRunTime getUserRunTime(IoSession session){
		return sessionIdRunTimeHt.get(session.getId());
	}
	public UserRunTime getUserRunTime(String user){
		return userRunTimeHt.get(user);
	}
	
	
	
	
	public boolean isConnected(IoSession session){
		if(sessionIdRunTimeHt.get(session.getId()) == null){
			return false;
		}else{
			return sessionIdRunTimeHt.get(session.getId()).getConnNum() > 0;
		}
	}
	
}
