package com.aspire.nm.component.cmppserver.runTime;

import java.util.Iterator;
import java.util.Map.Entry;

import javax.annotation.Resource;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import com.aspire.nm.component.cmppserver.ClientConfig;
import com.aspire.nm.component.cmppserver.runTime.counter.FailDetailCounter;
import com.aspire.nm.component.commonUtil.SystemInfo.SysInfo;
import com.aspire.nm.component.commonUtil.SystemInfo.SysInfoBean;
import com.aspire.nm.component.commonUtil.date.DateUtil;


@Service
public class RunTimeInfoBuilder extends Thread implements InitializingBean{
	
	@Resource
	private SysRunTimeService sysRunTimeService;
	
	private final String _r_n  = "\r\n";
//	private final String _r_n  = "<br/>";
	private final String _t  = "\t";
//	private final String _t  = "&nbsp;&nbsp;&nbsp;&nbsp;";
	
	public String build() throws Exception{
		StringBuffer sb = new StringBuffer();
		sb.append("启动时间  :" + sysRunTimeService.getSystemStartTime());sb.append(_r_n);
		sb.append("服务器参数  " );sb.append(_r_n);
		
		SysInfoBean sysInfoBean = SysInfo.getSysInfo();
			sb.append(_t+"操作系统  : " +sysInfoBean.getOsName());sb.append(_r_n);
			sb.append(_t+"总的物理内存   :" +sysInfoBean.getTotalMemorySize());sb.append(_r_n);
			sb.append(_t+"最大可使用内存   :" +sysInfoBean.getMaxMemory());sb.append(_r_n);
			sb.append(_t+"可使用内存   :" +sysInfoBean.getTotalMemory());sb.append(_r_n);
			sb.append(_t+"剩余内存   :" +sysInfoBean.getFreeMemory());sb.append(_r_n);
			sb.append(_t+"剩余的物理内存  : " +sysInfoBean.getFreePhysicalMemorySize());sb.append(_r_n);
			sb.append(_t+"已使用的物理内存  : " +sysInfoBean.getUsedMemory());sb.append(_r_n);
			sb.append(_t+"线程总数  : " +sysInfoBean.getTotalThread());sb.append(_r_n);
			sb.append(_t+"cpu使用率  : " +sysInfoBean.getCpuRatio());sb.append(_r_n);
		sb.append("统计数据 " );sb.append(_r_n);
			sb.append(_t+"非法请求 " );sb.append(_r_n);
				sb.append(_t+_t+"拒绝IP: 总数="+sysRunTimeService.getForBiddenIpCount().getCount()+",今日="+sysRunTimeService.getForBiddenIpCount().getDailyCount().getCount()+",昨日="+sysRunTimeService.getForBiddenIpCount().getDailyCount().getYesToDayCount());sb.append(_r_n);
				sb.append(_t+_t+"非法的CMPP: 总数="+sysRunTimeService.getForbiddenCmppCount().getCount()+",今日="+sysRunTimeService.getForbiddenCmppCount().getDailyCount().getCount()+",昨日="+sysRunTimeService.getForbiddenCmppCount().getDailyCount().getYesToDayCount());sb.append(_r_n);
			sb.append(_t+"合法请求 " );sb.append(_r_n);
				sb.append(_t+_t+"接收下行请求 : 总数="+sysRunTimeService.getMoMtCounter().getMtCounter().getSpeedCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getMtCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getMtCounter().getDailyCount().getYesToDayCount()+",即时速度="+sysRunTimeService.getMoMtCounter().getMtCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getMtCounter().getLastCountTimes()));sb.append(_r_n);
				sb.append(_t+_t+"发送下行应答(成功) : 总数="+sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getYesToDayCount()+",即时速度="+sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getMtRespSucessCounter().getLastCountTimes()));sb.append(_r_n);
				sb.append(_t+_t+"发送下行应答(失败) : 总数="+sysRunTimeService.getMoMtCounter().getMtRespFailCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getMtRespFailCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getMtRespFailCounter().getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getMtRespFailCounter().getLastCountTimes()));sb.append(_r_n);
for (Entry<String, FailDetailCounter> entry : sysRunTimeService.getMoMtCounter().getMtRespFailCounter().getDetailMap().entrySet()){
String detail = entry.getKey();
FailDetailCounter c = entry.getValue();
					sb.append(_t+_t+_t+detail +" : 总数="+c.getCount()+"，今日="+c.getDailyCount().getCount()+"，昨日="+c.getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(c.getLastCountTimes()));sb.append(_r_n);
}
				sb.append(_t+_t+"发送上行 : 总数="+sysRunTimeService.getMoMtCounter().getMoCounter().getSpeedCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getMoCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getMoCounter().getDailyCount().getYesToDayCount()+",即时速度="+sysRunTimeService.getMoMtCounter().getMoCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getMoCounter().getLastCountTimes()));sb.append(_r_n);
				sb.append(_t+_t+"发送状态报告: 总数="+sysRunTimeService.getMoMtCounter().getReportCounter().getSpeedCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getReportCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getReportCounter().getDailyCount().getYesToDayCount()+",即时速度="+sysRunTimeService.getMoMtCounter().getReportCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getReportCounter().getLastCountTimes()));sb.append(_r_n);
				sb.append(_t+_t+"接收上行或状态报告应答 : 总数="+sysRunTimeService.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCount()+"，今日="+sysRunTimeService.getMoMtCounter().getMoReportRespCounter().getDailyCount().getCount()+"，昨日="+sysRunTimeService.getMoMtCounter().getMoReportRespCounter().getDailyCount().getYesToDayCount()+",即时速度="+sysRunTimeService.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(sysRunTimeService.getMoMtCounter().getMoReportRespCounter().getLastCountTimes()));sb.append(_r_n);
				sb.append(_t+_t+"上行重发="+sysRunTimeService.getResendTimes());sb.append(_r_n);

for(Iterator<String> it =sysRunTimeService.getUserRunTimeHt().keySet().iterator();it.hasNext();) {
 String user = (String)it.next();
 UserRunTime userRunTime = sysRunTimeService.getUserRunTime(user);
 ClientConfig clientConfig = userRunTime.getClientConfig();
 
		sb.append("接入详情" );sb.append(_r_n);
			sb.append(_t+user);sb.append(_r_n);
				sb.append(_t+_t+"接入配置  " );sb.append(_r_n);
					sb.append(_t+_t+_t+"IP="+clientConfig.getIp());sb.append(",");
					sb.append("接入密码="+clientConfig.getPass());sb.append(",");
					sb.append("最大连接数 ="+clientConfig.getMaxConnNum());sb.append(",");
					sb.append("SRCID="+clientConfig.getSrcid());sb.append(",");
					sb.append("每日下行限制="+clientConfig.getDayMtLimit());sb.append(",");
					sb.append("每秒下行限制="+clientConfig.getMtLimitInSec());sb.append(",");
					sb.append("每秒上行限制="+clientConfig.getMoLimitInSec());sb.append(",");
					sb.append("白名单="+clientConfig.getWhileDestTerminalIds());sb.append(",");
					sb.append("黑名单="+clientConfig.getBlackDestTerminalIds());sb.append(",");
					sb.append("客户端技术联系人="+clientConfig.getUsername());sb.append(_r_n);
				sb.append(_t+_t+"综合统计 " );sb.append(_r_n);
					sb.append(_t+_t+_t+"接收下行请求:总数="+userRunTime.getMoMtCounter().getMtCounter().getSpeedCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getMtCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getMtCounter().getDailyCount().getYesToDayCount()+",即时速度="+userRunTime.getMoMtCounter().getMtCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getMtCounter().getLastCountTimes()));sb.append(_r_n);
					sb.append(_t+_t+_t+"发送下行应答(成功):总数="+userRunTime.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getYesToDayCount()+",即时速度="+userRunTime.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getMtRespSucessCounter().getLastCountTimes()));sb.append(_r_n);
					sb.append(_t+_t+_t+"发送下行应答(失败):总数="+userRunTime.getMoMtCounter().getMtRespFailCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getMtRespFailCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getMtRespFailCounter().getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getMtRespFailCounter().getLastCountTimes()));sb.append(_r_n);
for (Entry<String, FailDetailCounter> entry : userRunTime.getMoMtCounter().getMtRespFailCounter().getDetailMap().entrySet()){
String detail = entry.getKey();
FailDetailCounter c = entry.getValue();
						sb.append(_t+_t+_t+_t+detail +" : 总数="+c.getCount()+"，今日="+c.getDailyCount().getCount()+"，昨日="+c.getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(c.getLastCountTimes()));sb.append(_r_n);
}
					sb.append(_t+_t+_t+"发送上行:总数="+userRunTime.getMoMtCounter().getMoCounter().getSpeedCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getMoCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getMoCounter().getDailyCount().getYesToDayCount()+",即时速度="+userRunTime.getMoMtCounter().getMoCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getMoCounter().getLastCountTimes()));sb.append(_r_n);
					sb.append(_t+_t+_t+"发送状态报告:总数="+userRunTime.getMoMtCounter().getReportCounter().getSpeedCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getReportCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getReportCounter().getDailyCount().getYesToDayCount()+",即时速度="+userRunTime.getMoMtCounter().getReportCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getReportCounter().getLastCountTimes()));sb.append(_r_n);
					sb.append(_t+_t+_t+"接收上行或状态报告应答:总数="+userRunTime.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCount()+",今日="+userRunTime.getMoMtCounter().getMoReportRespCounter().getDailyCount().getCount()+",昨日="+userRunTime.getMoMtCounter().getMoReportRespCounter().getDailyCount().getYesToDayCount()+",即时速度="+userRunTime.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(userRunTime.getMoMtCounter().getMoReportRespCounter().getLastCountTimes()));sb.append(_r_n);
					sb.append(_t+_t+_t+"上行重发="+userRunTime.getResendTimes());sb.append(_r_n);
				sb.append(_t+_t+"获取上行内存队列大小="+userRunTime.getmOQueue().size());sb.append(_r_n);
				sb.append(_t+_t+"连接  " );sb.append(_r_n);
		for(Connection connection:userRunTime.getConnections()){
			
					sb.append(_t+_t+_t+connection.getId());sb.append(_r_n);
						sb.append(_t+_t+_t+_t+"建链时间 ="+connection.getConnStartTime());sb.append(_r_n);
						sb.append(_t+_t+_t+_t+"建链版本 ="+connection.getVersion().getDescription());sb.append(_r_n);
						sb.append(_t+_t+_t+_t+"发送上行内存(等待应答)队列大小=:"+connection.getMoSender().getDeliveryRetryHt().size());sb.append(_r_n);
						sb.append(_t+_t+_t+_t+"综合统计 :" );sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"接收下行请求:总数="+connection.getMoMtCounter().getMtCounter().getSpeedCounter().getCount()+",今日="+connection.getMoMtCounter().getMtCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getMtCounter().getDailyCount().getYesToDayCount()+",即时速度="+connection.getMoMtCounter().getMtCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getMtCounter().getLastCountTimes()));sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"发送下行应答(成功):总数="+connection.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCount()+",今日="+connection.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getMtRespSucessCounter().getDailyCount().getYesToDayCount()+",即时速度="+connection.getMoMtCounter().getMtRespSucessCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getMtRespSucessCounter().getLastCountTimes()));sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"发送下行请求 (失败):总数="+connection.getMoMtCounter().getMtRespFailCounter().getCount()+",今日="+connection.getMoMtCounter().getMtRespFailCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getMtRespFailCounter().getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getMtRespFailCounter().getLastCountTimes()));sb.append(_r_n);
for (Entry<String, FailDetailCounter> entry : connection.getMoMtCounter().getMtRespFailCounter().getDetailMap().entrySet()){
String detail = entry.getKey();
FailDetailCounter c = entry.getValue();
								sb.append(_t+_t+_t+_t+_t+_t+detail +" : 总数="+c.getCount()+"，今日="+c.getDailyCount().getCount()+"，昨日="+c.getDailyCount().getYesToDayCount()+",最后时间="+DateUtil.getTimeFromCurrent(c.getLastCountTimes()));sb.append(_r_n);
}
							sb.append(_t+_t+_t+_t+_t+"发送上行:总数="+connection.getMoMtCounter().getMoCounter().getSpeedCounter().getCount()+",今日="+connection.getMoMtCounter().getMoCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getMoCounter().getDailyCount().getYesToDayCount()+",即时速度="+connection.getMoMtCounter().getMoCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getMoCounter().getLastCountTimes()));sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"发送状态报告:总数="+connection.getMoMtCounter().getReportCounter().getSpeedCounter().getCount()+",今日="+connection.getMoMtCounter().getReportCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getReportCounter().getDailyCount().getYesToDayCount()+",即时速度="+connection.getMoMtCounter().getReportCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getReportCounter().getLastCountTimes()));sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"接收上行或状态报告应答:总数="+connection.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCount()+",今日="+connection.getMoMtCounter().getMoReportRespCounter().getDailyCount().getCount()+",昨日="+connection.getMoMtCounter().getMoReportRespCounter().getDailyCount().getYesToDayCount()+",即时速度="+connection.getMoMtCounter().getMoReportRespCounter().getSpeedCounter().getCountPerSec()+"/s,最后时间="+DateUtil.getTimeFromCurrent(connection.getMoMtCounter().getMoReportRespCounter().getLastCountTimes()));sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"上行重发="+connection.getResendTimes());sb.append(_r_n);
							sb.append(_t+_t+_t+_t+_t+"发送(接收)心跳:最后时间="+DateUtil.getTimeFromCurrent(connection.getActiveLastTime()));sb.append(_r_n);
		}				
}							
		return sb.toString();
	}

	@Override
	public void afterPropertiesSet() throws Exception {
//		start();
	}
	
	
	public void run(){
		while(true){
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
//			System.out.println(build());
		}
	}
}

