package com.aspire.nm.component.cmppserver.runTime;


import java.net.InetSocketAddress;

import javax.annotation.Resource;

import org.apache.mina.core.session.IoSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.aspire.nm.component.cmppserver.filter.coder.packet.Version;
import com.aspire.nm.component.cmppserver.runTime.counter.MoMtCounter;
import com.aspire.nm.component.cmppserver.runTime.moProcess.MoSender;
import com.aspire.nm.component.commonUtil.date.DateUtil;

@Scope("prototype")
@Component
public class Connection implements InitializingBean{
	
	@Override
	public void afterPropertiesSet() throws Exception {
		connStartTime = DateUtil.getCurDateTime();
	}
	
	private String connStartTime;
	public String getConnStartTime() {
		return connStartTime;
	}

	private long activeLastTime;
	public long getActiveLastTime() {
		return activeLastTime;
	}
	public void setActiveLastTime() {
		this.activeLastTime = System.currentTimeMillis();
	}

	
	@Resource
	private MoSender moSender;
	@Resource 
	private MoMtCounter moMtCounter;
	@Resource
	private SpeedController mtSpeedController;
	
	//上行超时重发
	private int resendTimes;
	public int getResendTimes() {
		return resendTimes;
	}
	public void setResendTimes(int resendTimes) {
		this.resendTimes = resendTimes;
	}
	
	
	
	public MoSender getMoSender() {
		return moSender;
	}
	public MoMtCounter getMoMtCounter() {
		return moMtCounter;
	}
	public SpeedController getMtSpeedController() {
		return mtSpeedController;
	}

	private UserRunTime userRunTime;
	private IoSession session;
	private Version version;
	
	
	
	public UserRunTime getUserRunTime() {
		return userRunTime;
	}
	public void setUserRunTime(UserRunTime userRunTime) {
		this.userRunTime = userRunTime;
	}
	public IoSession getSession() {
		return session;
	}
	public void setSession(IoSession session) {
		this.session = session;
	}
	public Version getVersion() {
		return version;
	}
	public void setVersion(Version version) {
		this.version = version;
	}
	
	
	
	
	
	public String getId(){
		return ((InetSocketAddress) session.getRemoteAddress()).getAddress().toString()+":"+((InetSocketAddress) session.getRemoteAddress()).getPort();
	}
	public boolean isMoConn(){
		return version.getMinor() != 0x0F;
	}
	
	
	
	
	
	public boolean equals(Object obj){
		if(obj instanceof IoSession){
			return ((IoSession)obj).getId() == session.getId();
		}else{
			return false;
		}
	}
}
