/*
 * @ (#) Version.java Jun 8, 2008
 *
 * 
 */
package com.aspire.nm.component.cmppserver.filter.coder.packet;

/**
 *	CMPP版本号
 *	在CMCPP_CONNECT封包中以8位存储, 高4位为主版本, 低四位为次版本
 *
 * @author	Wang Shenggong
 * @version 1.0.0
 * @since 1.0.0
 *
 */
public class Version implements java.io.Serializable{	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 主版本, 仅依据数字意义(即有效数字在低4位)
	private byte major;
	
	// 次版本
	private byte minor;
	
	// 版本
	private byte version;
	
	
	// 描述
	private String description;
	
	// CMPP2.0版本标识(上下行)
	public static Version CMPP2_0_VERSION = new Version((byte)0x20, "CMPP v2.0 MOMT");
	public static Version CMPP2_0_VERSION_1 = new Version((byte)20, "CMPP v2.0 MOMT[ver=20]");
	
	// CMPP2.0版本标识(上行)
	public static Version CMPP2_0_VERSION_MO = new Version((byte)0x2E, "CMPP v2.0 MO");
	
	// CMPP2.0版本标识(下行)
	public static Version CMPP2_0_VERSION_MT = new Version((byte)0x2F, "CMPP v2.0 MT");
	
	// CMPP3.0版本标识(上下行)
	public static Version CMPP3_0_VERSION = new Version((byte)0x30, "CMPP v3.0 MOMT");
	public static Version CMPP3_0_VERSION_1 = new Version((byte)30, "CMPP v3.0 MOMT[ver=30]");
	
	// CMPP3.0版本标识(上行)
	public static Version CMPP3_0_VERSION_MO = new Version((byte)0x3E, "CMPP v3.0 MO");
	public static Version CMPP3_0_VERSION_MO_1 = new Version((byte)0x01, "CMPP v3.0 MO[ver=1]");
	
	// CMPP3.0版本标识(下行)
	public static Version CMPP3_0_VERSION_MT = new Version((byte)0x3F, "CMPP v3.0 MT");
	public static Version CMPP3_0_VERSION_MT_1 = new Version((byte)0x00, "CMPP v3.0 MT[ver=0]");
	
	// USMP4.0版本标识(PUSH)
	public static Version USMP4_0_VERSION = new Version((byte)0x40, "USMP v4.0 PUSH");
	
	// UNKNOW
	public static Version UNKNOW_VERSION = new Version((byte)0xFF, "UNKNOW_VERSION");
	
	/**
	 * 有8位版本标识和版本描述构造版本标识对象
	 * 
	 * @param v
	 * @param desc
	 */
	public Version(byte v, String desc){
		version = v;
		major = (byte)((v & 0xf0) >> 4);
		minor = (byte)(v & 0x0f);
		description = desc;
	}
	
	/**
	 * 用主次版本号和版本描述构造版本标识对象, 其中主版本仅依据数字意义(即有效数字在低4位)
	 * @param major
	 * @param minor
	 * @param desc
	 */
	public Version(byte major, byte minor, String desc){
		this.major = (byte)(major & 0x0f);
		this.minor = (byte)(minor & 0x0f);
		version = (byte)((major << 4) + minor);
		description = desc;
	}
	
	/**
	 * 判断两个版本是否相同
	 */
	public boolean equals(Object obj){
		if(obj == null || !(obj instanceof Version)) return false;
		
		return version == ((Version)obj).version ? true : false;
		
	}

	/**
	 * 判断是否比给定版本号大
	 * @param v 指定比较的版本
	 * @return 如果指定版本比当前版本号大则返回true,否则返回false
	 */
	public boolean isLarge(Version v){
		return version > v.version;
	}
	
	/**
	 * 判断是否比给定版本号小
	 * @param v 指定比较的版本
	 * @return 如果指定版本比当前版本号小则返回true,否则返回false
	 */
	public boolean isLittle(Version v){
		return version < v.version;
	}
	/**
	 * 转换Version
	 * @param ver
	 * @return
	 */
	public static Version toVersion(int ver){
		Version version = Version.UNKNOW_VERSION;
		if(ver == Version.CMPP2_0_VERSION.getVersion())
			version = Version.CMPP2_0_VERSION;
		else if(ver == Version.CMPP2_0_VERSION_1.getVersion())
			version = Version.CMPP2_0_VERSION_1;
		else if(ver == Version.CMPP2_0_VERSION_MO.getVersion())
			version = Version.CMPP2_0_VERSION_MO;
		else if(ver == Version.CMPP2_0_VERSION_MT.getVersion())
			version = Version.CMPP2_0_VERSION_MT;
		else if(ver == Version.CMPP3_0_VERSION.getVersion())
			version = Version.CMPP3_0_VERSION;
		else if(ver == Version.CMPP3_0_VERSION_1.getVersion())
			version = Version.CMPP3_0_VERSION_1;
		else if(ver == Version.CMPP3_0_VERSION_MO.getVersion())
			version = Version.CMPP3_0_VERSION_MO;
		else if(ver == Version.CMPP3_0_VERSION_MT.getVersion())
			version = Version.CMPP3_0_VERSION_MT;
		else if(ver == Version.USMP4_0_VERSION.getVersion())
			version = Version.USMP4_0_VERSION;
		else if(ver == Version.CMPP3_0_VERSION_MO_1.getVersion())
			version = Version.CMPP3_0_VERSION_MO;
		else if(ver == Version.CMPP3_0_VERSION_MT_1.getVersion())
			version = Version.CMPP3_0_VERSION_MT;
		else
			version = Version.UNKNOW_VERSION;
		return version;
	}
	
	// -- public - get & set --------------------------------------------------
	/**
	 * @return the major
	 */
	/*public byte getMajor() {
		return major;
	}
   */
	/**
	 * @return the minor
	 *
	 */
	public byte getMinor() {
		return minor;
	}
	
	public boolean isSingleMOVersion(){
		return minor==0x0E&&version!=30;
	}
	public boolean isSingleMTVersion(){
		return minor==0x0F;
	}

	/**
	 * @return the version
	 */
	public byte getVersion() {
		return version;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	
	public boolean isVersion3(){
		return major == Version.CMPP3_0_VERSION.major||version==Version.CMPP3_0_VERSION_1.version;
	}
	
	public boolean isVersion2(){
		return major == Version.CMPP2_0_VERSION.major||version==Version.CMPP2_0_VERSION_1.version;
	}
	
	public boolean isVersion4(){
		return major == Version.USMP4_0_VERSION.major;
	}
	
	public String toString(){
		return getDescription();
	}
}
